/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource.data.processor;

import com.google.common.collect.Lists;
import com.sigmundgranaas.forgero.core.identifier.Common;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ConstructData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.DataResource;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.IngredientData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ResourceType;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SchematicConstructInflater {
    private final DataResource resource;
    private final Function<String, List<DataResource>> typeFinder;
    private final Function<String, Optional<DataResource>> idFinder;
    private final Function<String, Optional<DataResource>> templateProvider;

    public SchematicConstructInflater(DataResource resource, Function<String, List<DataResource>> typeFinder, Function<String, Optional<DataResource>> idFinder, Function<String, Optional<DataResource>> templateProvider) {
        this.resource = resource;
        this.typeFinder = typeFinder;
        this.idFinder = idFinder;
        this.templateProvider = templateProvider;
    }

    public List<DataResource> process() {
        if (this.invalidData()) {
            return Collections.emptyList();
        }
        List<List<IngredientData>> templateIngredients = this.inflateIngredients();
        return this.mapTemplateIngredients(templateIngredients);
    }

    private List<List<IngredientData>> inflateIngredients() {
        ArrayList<List<IngredientData>> templateIngredients = new ArrayList<List<IngredientData>>();
        List components = this.resource.construct().map(ConstructData::components).orElse(Collections.emptyList());
        for (IngredientData ingredient : components) {
            templateIngredients.add(this.getIngredientDataList(ingredient));
        }
        return templateIngredients;
    }

    private List<IngredientData> getIngredientDataList(IngredientData ingredient) {
        if (this.isThis(ingredient)) {
            return List.of(IngredientData.builder().id(this.resource.identifier()).unique(true).build());
        }
        if (this.isTyped(ingredient)) {
            return ingredient.unique() ? this.findUniqueIngredients(ingredient.type()) : this.findDefaultIngredients(ingredient.type());
        }
        if (this.isId(ingredient)) {
            return List.of(ingredient);
        }
        return Collections.emptyList();
    }

    private List<DataResource> mapTemplateIngredients(List<List<IngredientData>> templateIngredients) {
        ArrayList<DataResource> constructs = new ArrayList<DataResource>();
        List product = Lists.cartesianProduct(templateIngredients);
        for (List combination : product) {
            constructs.add(this.buildDataResource(combination));
        }
        return constructs;
    }

    private DataResource buildDataResource(List<IngredientData> components) {
        ConstructData.ConstructDataBuilder builder = this.resource.construct().get().toBuilder();
        builder.components(components);
        String name = String.join((CharSequence)Common.ELEMENT_SEPARATOR, components.stream().map(IngredientData::id).map(this::idToName).toList());
        builder.target(Identifiers.THIS_IDENTIFIER);
        ConstructData construct = builder.build();
        DataResource.DataResourceBuilder templateBuilder = this.templateProvider.apply(construct.type()).map(DataResource::toBuilder).orElse(DataResource.builder());
        if (this.hasDefaults(construct) || this.resource.resourceType() == ResourceType.DEFAULT || name.equals("handle-schematic-oak")) {
            templateBuilder.resourceType(ResourceType.DEFAULT);
        }
        return templateBuilder.construct(construct).namespace(this.resource.nameSpace()).container(this.resource.container().get()).name(name).type(construct.type()).build();
    }

    private String idToName(String id) {
        String[] split = id.split(":");
        if (split.length > 1) {
            return split[1];
        }
        return id;
    }

    private boolean hasDefaults(ConstructData data) {
        return data.components().stream().allMatch(ingredient -> {
            if (ingredient.id().equals(Identifiers.EMPTY_IDENTIFIER)) {
                return false;
            }
            if (ingredient.id().equals("handle_schematic")) {
                return true;
            }
            Optional<DataResource> res = this.idFinder.apply(ingredient.id());
            return res.filter(resource -> resource.resourceType() == ResourceType.DEFAULT).isPresent();
        });
    }

    private boolean isTyped(IngredientData data) {
        return !data.type().equals(Identifiers.EMPTY_IDENTIFIER);
    }

    private boolean isId(IngredientData data) {
        return !data.id().equals(Identifiers.EMPTY_IDENTIFIER);
    }

    private boolean isThis(IngredientData data) {
        return this.isId(data) && data.id().equals(Identifiers.THIS_IDENTIFIER);
    }

    private boolean invalidData() {
        return this.resource.construct().isEmpty();
    }

    private List<IngredientData> findUniqueIngredients(String type) {
        return this.typeFinder.apply(type).stream().map(res -> IngredientData.builder().id(res.identifier()).unique(true).build()).toList();
    }

    private List<IngredientData> findDefaultIngredients(String type) {
        return this.typeFinder.apply(type).stream().filter(res -> res.resourceType() == ResourceType.DEFAULT).map(res -> IngredientData.builder().id(res.identifier()).unique(true).build()).toList();
    }

    public Set<String> dependencies() {
        return this.resource.construct().map(ConstructData::components).map(list -> list.stream().map(ingredient -> ingredient.id().equals(Identifiers.EMPTY_IDENTIFIER) ? ingredient.id() : ingredient.type()).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }
}

