/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource.data.v2;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.DataResource;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.IngredientData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ResourceType;
import com.sigmundgranaas.forgero.core.resource.data.v2.factory.TypeFactory;
import com.sigmundgranaas.forgero.core.state.Ingredient;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.composite.Construct;
import com.sigmundgranaas.forgero.core.state.composite.Constructed;
import com.sigmundgranaas.forgero.core.type.ResolvedTypeTree;
import com.sigmundgranaas.forgero.core.type.TypeTree;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ResourcePool {
    private final ImmutableList<DataResource> resources;
    private final TypeTree tree;
    private final List<DataResource> resolvedConstructs;
    private final List<DataResource> unresolvedConstructs;
    private final List<Constructed> constructs;

    public ResourcePool(ImmutableList<DataResource> resources) {
        this.resources = resources;
        this.resolvedConstructs = new ArrayList<DataResource>();
        this.unresolvedConstructs = new ArrayList<DataResource>();
        this.constructs = new ArrayList<Constructed>();
        this.tree = new TypeTree();
    }

    public ResolvedTypeTree createLoadedTypeTree() {
        new TypeFactory().convertJsonToData((List<DataResource>)this.resources).forEach(this.tree::addNode);
        this.tree.resolve();
        Map resourceMap = this.resources.stream().filter(resource -> Objects.nonNull(resource.name()) && !resource.name().equals(Identifiers.EMPTY_IDENTIFIER)).filter(resource -> resource.resourceType() != ResourceType.TYPE_DEFINITION).collect(Collectors.groupingBy(DataResource::type, Collectors.mapping(resource -> resource, Collectors.toList())));
        resourceMap.forEach((entry, values) -> this.tree.find((String)entry).ifPresent(node -> values.stream().map(this::resourceToIngredient).flatMap(Optional::stream).forEach(ingredient -> node.addResource(ingredient, Ingredient.class))));
        this.resources.stream().filter(resource -> resource.construct().isPresent()).forEach(this.unresolvedConstructs::add);
        boolean remainingResources = true;
        while (remainingResources) {
            int resolvedResources = 0;
            ArrayList temporaryResolved = new ArrayList();
            this.unresolvedConstructs.forEach(resource -> {
                assert (resource.construct().isPresent());
                assert (resource.construct().get().recipes().isPresent());
                List<IngredientData> ingredients = resource.construct().get().recipes().get().get(0).ingredients();
                boolean resolved = true;
                ArrayList resourceIngredients = new ArrayList();
                for (IngredientData ingredient : ingredients) {
                    int ingredientCount = resourceIngredients.size();
                    if (ingredient.id().equals("this")) {
                        this.resourceToIngredient((DataResource)resource).ifPresent(resourceIngredients::add);
                    } else {
                        resourceIngredients.addAll((Collection)this.tree.find(ingredient.type()).map(node -> node.getResources(Ingredient.class)).orElse(ImmutableList.builder().build()));
                    }
                    if (ingredientCount != resourceIngredients.size()) continue;
                    resolved = false;
                }
                if (resolved) {
                    temporaryResolved.add(resource);
                }
            });
            for (DataResource resource2 : temporaryResolved) {
                this.unresolvedConstructs.remove(resource2);
                this.resolvedConstructs.add(resource2);
            }
            this.resolvedConstructs.stream().map(this::constructToComposite).flatMap(Collection::stream).map(Ingredient::of).forEach(comp -> this.tree.find(comp.type().typeName()).ifPresent(node -> node.addResource(comp, Ingredient.class)));
            resolvedResources = temporaryResolved.size();
            if (resolvedResources != 0) continue;
            remainingResources = false;
        }
        this.resolvedConstructs.stream().map(this::constructToComposite).flatMap(Collection::stream).forEach(this.constructs::add);
        return this.tree.resolve();
    }

    private Optional<Ingredient> resourceToIngredient(DataResource resource) {
        if (resource.properties().isPresent()) {
            return Optional.of(Ingredient.of(resource.name(), this.tree.type(resource.type()), Collections.emptyList()));
        }
        return Optional.empty();
    }

    private List<Construct> constructToComposite(DataResource resource) {
        List<IngredientData> jsonIngredients = resource.construct().get().recipes().get().get(0).ingredients();
        ArrayList<List<Ingredient>> templateIngredients = new ArrayList<List<Ingredient>>();
        for (IngredientData ingredient : jsonIngredients) {
            List ingredients;
            if (ingredient.id() != null && ingredient.id().equals("this")) {
                Ingredient thisIngredient = this.resourceToIngredient(resource).orElseThrow();
                templateIngredients.add(List.of(thisIngredient));
                continue;
            }
            if (ingredient.type() == null) continue;
            if (ingredient.unique()) {
                ingredients = this.tree.find(ingredient.type()).map(node -> node.getResources(Ingredient.class)).map(Collection::stream).map(Stream::toList).orElse(Collections.emptyList());
                templateIngredients.add(ingredients);
                continue;
            }
            ingredients = this.tree.find(ingredient.type()).map(node -> node.getResources(Ingredient.class)).map(element -> element.stream().findFirst().map(List::of).orElse(Collections.emptyList())).orElse(Collections.emptyList());
            templateIngredients.add(ingredients);
        }
        ArrayList<Construct> composites = new ArrayList<Construct>();
        for (int i = 0; i < ((List)templateIngredients.get(0)).size(); ++i) {
            for (int j = 0; j < ((List)templateIngredients.get(1)).size(); ++j) {
                Construct.ConstructBuilder builder = Construct.builder();
                builder.addIngredient((State)((List)templateIngredients.get(0)).get(i));
                builder.type(this.tree.type(resource.construct().get().type()));
                builder.addIngredient((State)((List)templateIngredients.get(1)).get(j));
                composites.add(builder.build());
            }
        }
        return composites;
    }
}

