/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource.data.v2.data;

import com.sigmundgranaas.forgero.core.resource.data.v2.data.IngredientData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.RecipeData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.SlotData;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class ConstructData {
    @Nullable
    private final List<RecipeData> recipes;
    @Nullable
    private final boolean container;
    @Nullable
    private final List<IngredientData> components;
    @Nullable
    private final String target;
    @Nullable
    private final String type;
    @Nullable
    private final List<SlotData> slots;

    public boolean container() {
        return this.container;
    }

    @NotNull
    public String target() {
        return Objects.requireNonNullElse(this.target, Identifiers.EMPTY_IDENTIFIER);
    }

    @NotNull
    public String type() {
        return Objects.requireNonNullElse(this.type, Identifiers.EMPTY_IDENTIFIER);
    }

    @NotNull
    public List<SlotData> slots() {
        return Objects.requireNonNullElse(this.slots, Collections.emptyList());
    }

    @NotNull
    public List<IngredientData> components() {
        return Objects.requireNonNullElse(this.components, Collections.emptyList());
    }

    public Optional<List<RecipeData>> recipes() {
        return Optional.ofNullable(this.recipes);
    }

    private static boolean $default$container() {
        return false;
    }

    private static List<IngredientData> $default$components() {
        return Collections.emptyList();
    }

    private static String $default$target() {
        return Identifiers.THIS_IDENTIFIER;
    }

    private static String $default$type() {
        return Identifiers.EMPTY_IDENTIFIER;
    }

    private static List<SlotData> $default$slots() {
        return Collections.emptyList();
    }

    ConstructData(@Nullable List<RecipeData> recipes, @Nullable boolean container, @Nullable List<IngredientData> components, @Nullable String target, @Nullable String type, @Nullable List<SlotData> slots) {
        this.recipes = recipes;
        this.container = container;
        this.components = components;
        this.target = target;
        this.type = type;
        this.slots = slots;
    }

    public static ConstructDataBuilder builder() {
        return new ConstructDataBuilder();
    }

    public ConstructDataBuilder toBuilder() {
        return new ConstructDataBuilder().recipes(this.recipes).container(this.container).components(this.components).target(this.target).type(this.type).slots(this.slots);
    }

    public static class ConstructDataBuilder {
        private List<RecipeData> recipes;
        private boolean container$set;
        private boolean container$value;
        private boolean components$set;
        private List<IngredientData> components$value;
        private boolean target$set;
        private String target$value;
        private boolean type$set;
        private String type$value;
        private boolean slots$set;
        private List<SlotData> slots$value;

        ConstructDataBuilder() {
        }

        public ConstructDataBuilder recipes(@Nullable List<RecipeData> recipes) {
            this.recipes = recipes;
            return this;
        }

        public ConstructDataBuilder container(@Nullable boolean container) {
            this.container$value = container;
            this.container$set = true;
            return this;
        }

        public ConstructDataBuilder components(@Nullable List<IngredientData> components) {
            this.components$value = components;
            this.components$set = true;
            return this;
        }

        public ConstructDataBuilder target(@Nullable String target) {
            this.target$value = target;
            this.target$set = true;
            return this;
        }

        public ConstructDataBuilder type(@Nullable String type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public ConstructDataBuilder slots(@Nullable List<SlotData> slots) {
            this.slots$value = slots;
            this.slots$set = true;
            return this;
        }

        public ConstructData build() {
            boolean container$value = this.container$value;
            if (!this.container$set) {
                container$value = ConstructData.$default$container();
            }
            List<IngredientData> components$value = this.components$value;
            if (!this.components$set) {
                components$value = ConstructData.$default$components();
            }
            String target$value = this.target$value;
            if (!this.target$set) {
                target$value = ConstructData.$default$target();
            }
            String type$value = this.type$value;
            if (!this.type$set) {
                type$value = ConstructData.$default$type();
            }
            List<SlotData> slots$value = this.slots$value;
            if (!this.slots$set) {
                slots$value = ConstructData.$default$slots();
            }
            return new ConstructData(this.recipes, container$value, components$value, target$value, type$value, slots$value);
        }

        public String toString() {
            return "ConstructData.ConstructDataBuilder(recipes=" + this.recipes + ", container$value=" + this.container$value + ", components$value=" + this.components$value + ", target$value=" + this.target$value + ", type$value=" + this.type$value + ", slots$value=" + this.slots$value + ")";
        }
    }
}

