/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource.data.v2.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.sigmundgranaas.forgero.core.customdata.CustomJsonDataContainer;
import com.sigmundgranaas.forgero.core.customdata.DataContainer;
import com.sigmundgranaas.forgero.core.resource.data.PropertyPojo;
import com.sigmundgranaas.forgero.core.resource.data.SchemaVersion;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ConstructData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ContextData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.DependencyData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.HostData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.JsonStatic;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ModelData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.PaletteData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ResourceType;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.namedElement;
import com.sigmundgranaas.forgero.core.state.Identifiable;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class DataResource
implements Identifiable {
    @Nullable
    private String name;
    @Nullable
    private String namespace;
    @Nullable
    private String type;
    @SerializedName(value="resource_type", alternate={"json_resource_type"})
    @Nullable
    private ResourceType resourceType;
    @Nullable
    private String parent;
    @Nullable
    private SchemaVersion version;
    @Nullable
    @SerializedName(value="dependencies", alternate={"dependency"})
    private DependencyData dependencies;
    @Nullable
    private ConstructData construct;
    @Nullable
    private List<ModelData> models;
    @Nullable
    @SerializedName(value="static", alternate={"json_static"})
    private JsonStatic jsonStatic;
    @Nullable
    private List<namedElement> children;
    @Nullable
    private ContextData context;
    @Nullable
    private HostData container;
    @Nullable
    private PaletteData palette;
    @Nullable
    @SerializedName(value="properties", alternate={"property"})
    private PropertyPojo property;
    private int priority;
    @SerializedName(value="custom_data")
    private Map<String, JsonElement> customData;

    public static <T> List<T> mergeProperty(List<T> attribute1, List<T> attribute2) {
        if (attribute1 == null && attribute2 == null) {
            return Collections.emptyList();
        }
        if (attribute1 != null && attribute2 != null) {
            return Stream.of(attribute1, attribute2).flatMap(Collection::stream).toList();
        }
        return Objects.requireNonNullElse(attribute1, attribute2);
    }

    public static List<PropertyPojo.Attribute> mergeAttributes(List<PropertyPojo.Attribute> first, List<PropertyPojo.Attribute> second) {
        if (DataResource.areAllListsNull(first, second)) {
            return Collections.emptyList();
        }
        if (DataResource.areNoListsNull(first, second)) {
            return DataResource.mergeNonNullAttributeLists(first, second);
        }
        return Objects.requireNonNullElse(first, second);
    }

    private static List<PropertyPojo.Attribute> mergeNonNullAttributeLists(List<PropertyPojo.Attribute> firstList, List<PropertyPojo.Attribute> secondList) {
        HashMap<String, PropertyPojo.Attribute> combinedAttributes = new HashMap<String, PropertyPojo.Attribute>();
        ArrayList<PropertyPojo.Attribute> others = new ArrayList<PropertyPojo.Attribute>();
        for (PropertyPojo.Attribute attr : firstList) {
            if (!attr.id.equals(Identifiers.EMPTY_IDENTIFIER)) {
                combinedAttributes.put(attr.id, attr);
                continue;
            }
            others.add(attr);
        }
        for (PropertyPojo.Attribute attr : secondList) {
            if (!attr.id.equals(Identifiers.EMPTY_IDENTIFIER)) {
                combinedAttributes.merge(attr.id, attr, DataResource::attributeMergeRule);
                continue;
            }
            others.add(attr);
        }
        others.addAll(combinedAttributes.values());
        return others;
    }

    private static PropertyPojo.Attribute attributeMergeRule(PropertyPojo.Attribute existingAttr, PropertyPojo.Attribute newAttr) {
        if (newAttr.priority > existingAttr.priority && newAttr.id.equals(existingAttr.id)) {
            return newAttr;
        }
        return existingAttr;
    }

    private static boolean areAllListsNull(List<?> ... lists) {
        for (List<?> list : lists) {
            if (list == null) continue;
            return false;
        }
        return true;
    }

    private static boolean areNoListsNull(List<?> ... lists) {
        for (List<?> list : lists) {
            if (list != null) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String name() {
        return Objects.requireNonNullElse(this.name, Identifiers.EMPTY_IDENTIFIER);
    }

    @Override
    @NotNull
    public String nameSpace() {
        return Objects.requireNonNullElse(this.namespace, Identifiers.EMPTY_IDENTIFIER);
    }

    public int priority() {
        return this.priority;
    }

    @NotNull
    public String type() {
        return this.type == null ? Identifiers.EMPTY_IDENTIFIER : this.type;
    }

    @NotNull
    public ResourceType resourceType() {
        return Objects.requireNonNullElse(this.resourceType, ResourceType.UNDEFINED);
    }

    @NotNull
    public String parent() {
        return Objects.requireNonNullElse(this.parent, Identifiers.EMPTY_IDENTIFIER);
    }

    @NotNull
    public DependencyData dependencies() {
        if (this.dependencies == null) {
            return DependencyData.empty();
        }
        return this.dependencies;
    }

    @NotNull
    public ImmutableList<ModelData> models() {
        if (this.models == null) {
            return ImmutableList.builder().build();
        }
        return ImmutableList.builder().addAll(this.models).build();
    }

    @NotNull
    public SchemaVersion version() {
        return Objects.requireNonNullElse(this.version, SchemaVersion.V2);
    }

    @NotNull
    public List<namedElement> children() {
        return Objects.requireNonNullElse(this.children, Collections.emptyList());
    }

    @NotNull
    public Optional<PropertyPojo> properties() {
        return Optional.ofNullable(this.property);
    }

    @NotNull
    public Optional<HostData> container() {
        return Optional.ofNullable(this.container);
    }

    @NotNull
    public Optional<ConstructData> construct() {
        return Optional.ofNullable(this.construct);
    }

    @NotNull
    public Optional<ContextData> context() {
        return Optional.ofNullable(this.context);
    }

    @NotNull
    public Optional<PaletteData> palette() {
        return Optional.ofNullable(this.palette);
    }

    public DataResource mergeResource(DataResource resource) {
        DataResourceBuilder builder = this.toBuilder();
        PropertyPojo properties = this.properties().orElse(new PropertyPojo());
        PropertyPojo mergeProperties = resource.properties().orElse(new PropertyPojo());
        PropertyPojo newProps = new PropertyPojo();
        newProps.setAttributes(DataResource.mergeAttributes(properties.getAttributes(), mergeProperties.getAttributes()).stream().distinct().toList());
        newProps.features = DataResource.mergeProperty(mergeProperties.features, properties.features).stream().distinct().toList();
        return builder.property(newProps).build();
    }

    public DataContainer getCustomData() {
        return CustomJsonDataContainer.of(this.customData);
    }

    private static String $default$name() {
        return Identifiers.EMPTY_IDENTIFIER;
    }

    private static String $default$namespace() {
        return Identifiers.EMPTY_IDENTIFIER;
    }

    private static String $default$type() {
        return Identifiers.EMPTY_IDENTIFIER;
    }

    private static ResourceType $default$resourceType() {
        return ResourceType.UNDEFINED;
    }

    private static String $default$parent() {
        return Identifiers.EMPTY_IDENTIFIER;
    }

    private static SchemaVersion $default$version() {
        return SchemaVersion.V2;
    }

    private static List<namedElement> $default$children() {
        return Collections.emptyList();
    }

    private static int $default$priority() {
        return 5;
    }

    private static Map<String, JsonElement> $default$customData() {
        return new HashMap<String, JsonElement>();
    }

    DataResource(@Nullable String name, @Nullable String namespace, @Nullable String type, @Nullable ResourceType resourceType, @Nullable String parent, @Nullable SchemaVersion version, @Nullable DependencyData dependencies, @Nullable ConstructData construct, @Nullable List<ModelData> models, @Nullable JsonStatic jsonStatic, @Nullable List<namedElement> children, @Nullable ContextData context, @Nullable HostData container, @Nullable PaletteData palette, @Nullable PropertyPojo property, int priority, Map<String, JsonElement> customData) {
        this.name = name;
        this.namespace = namespace;
        this.type = type;
        this.resourceType = resourceType;
        this.parent = parent;
        this.version = version;
        this.dependencies = dependencies;
        this.construct = construct;
        this.models = models;
        this.jsonStatic = jsonStatic;
        this.children = children;
        this.context = context;
        this.container = container;
        this.palette = palette;
        this.property = property;
        this.priority = priority;
        this.customData = customData;
    }

    public static DataResourceBuilder builder() {
        return new DataResourceBuilder();
    }

    public DataResourceBuilder toBuilder() {
        return new DataResourceBuilder().name(this.name).namespace(this.namespace).type(this.type).resourceType(this.resourceType).parent(this.parent).version(this.version).dependencies(this.dependencies).construct(this.construct).models(this.models).jsonStatic(this.jsonStatic).children(this.children).context(this.context).container(this.container).palette(this.palette).property(this.property).priority(this.priority).customData(this.customData);
    }

    public static class DataResourceBuilder {
        private boolean name$set;
        private String name$value;
        private boolean namespace$set;
        private String namespace$value;
        private boolean type$set;
        private String type$value;
        private boolean resourceType$set;
        private ResourceType resourceType$value;
        private boolean parent$set;
        private String parent$value;
        private boolean version$set;
        private SchemaVersion version$value;
        private DependencyData dependencies;
        private ConstructData construct;
        private List<ModelData> models;
        private JsonStatic jsonStatic;
        private boolean children$set;
        private List<namedElement> children$value;
        private ContextData context;
        private HostData container;
        private PaletteData palette;
        private PropertyPojo property;
        private boolean priority$set;
        private int priority$value;
        private boolean customData$set;
        private Map<String, JsonElement> customData$value;

        DataResourceBuilder() {
        }

        public DataResourceBuilder name(@Nullable String name) {
            this.name$value = name;
            this.name$set = true;
            return this;
        }

        public DataResourceBuilder namespace(@Nullable String namespace) {
            this.namespace$value = namespace;
            this.namespace$set = true;
            return this;
        }

        public DataResourceBuilder type(@Nullable String type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public DataResourceBuilder resourceType(@Nullable ResourceType resourceType) {
            this.resourceType$value = resourceType;
            this.resourceType$set = true;
            return this;
        }

        public DataResourceBuilder parent(@Nullable String parent) {
            this.parent$value = parent;
            this.parent$set = true;
            return this;
        }

        public DataResourceBuilder version(@Nullable SchemaVersion version) {
            this.version$value = version;
            this.version$set = true;
            return this;
        }

        public DataResourceBuilder dependencies(@Nullable DependencyData dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public DataResourceBuilder construct(@Nullable ConstructData construct) {
            this.construct = construct;
            return this;
        }

        public DataResourceBuilder models(@Nullable List<ModelData> models) {
            this.models = models;
            return this;
        }

        public DataResourceBuilder jsonStatic(@Nullable JsonStatic jsonStatic) {
            this.jsonStatic = jsonStatic;
            return this;
        }

        public DataResourceBuilder children(@Nullable List<namedElement> children) {
            this.children$value = children;
            this.children$set = true;
            return this;
        }

        public DataResourceBuilder context(@Nullable ContextData context) {
            this.context = context;
            return this;
        }

        public DataResourceBuilder container(@Nullable HostData container) {
            this.container = container;
            return this;
        }

        public DataResourceBuilder palette(@Nullable PaletteData palette) {
            this.palette = palette;
            return this;
        }

        public DataResourceBuilder property(@Nullable PropertyPojo property) {
            this.property = property;
            return this;
        }

        public DataResourceBuilder priority(int priority) {
            this.priority$value = priority;
            this.priority$set = true;
            return this;
        }

        public DataResourceBuilder customData(Map<String, JsonElement> customData) {
            this.customData$value = customData;
            this.customData$set = true;
            return this;
        }

        public DataResource build() {
            String name$value = this.name$value;
            if (!this.name$set) {
                name$value = DataResource.$default$name();
            }
            String namespace$value = this.namespace$value;
            if (!this.namespace$set) {
                namespace$value = DataResource.$default$namespace();
            }
            String type$value = this.type$value;
            if (!this.type$set) {
                type$value = DataResource.$default$type();
            }
            ResourceType resourceType$value = this.resourceType$value;
            if (!this.resourceType$set) {
                resourceType$value = DataResource.$default$resourceType();
            }
            String parent$value = this.parent$value;
            if (!this.parent$set) {
                parent$value = DataResource.$default$parent();
            }
            SchemaVersion version$value = this.version$value;
            if (!this.version$set) {
                version$value = DataResource.$default$version();
            }
            List<namedElement> children$value = this.children$value;
            if (!this.children$set) {
                children$value = DataResource.$default$children();
            }
            int priority$value = this.priority$value;
            if (!this.priority$set) {
                priority$value = DataResource.$default$priority();
            }
            Map<String, JsonElement> customData$value = this.customData$value;
            if (!this.customData$set) {
                customData$value = DataResource.$default$customData();
            }
            return new DataResource(name$value, namespace$value, type$value, resourceType$value, parent$value, version$value, this.dependencies, this.construct, this.models, this.jsonStatic, children$value, this.context, this.container, this.palette, this.property, priority$value, customData$value);
        }

        public String toString() {
            return "DataResource.DataResourceBuilder(name$value=" + this.name$value + ", namespace$value=" + this.namespace$value + ", type$value=" + this.type$value + ", resourceType$value=" + this.resourceType$value + ", parent$value=" + this.parent$value + ", version$value=" + this.version$value + ", dependencies=" + this.dependencies + ", construct=" + this.construct + ", models=" + this.models + ", jsonStatic=" + this.jsonStatic + ", children$value=" + this.children$value + ", context=" + this.context + ", container=" + this.container + ", palette=" + this.palette + ", property=" + this.property + ", priority$value=" + this.priority$value + ", customData$value=" + this.customData$value + ")";
        }
    }
}

