/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource.data.v2.data;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class DependencyData {
    @SerializedName(value="dependencies", alternate={"all"})
    private Set<String> dependencies;
    @SerializedName(value="any", alternate={"any_of"})
    private Set<String> any_of;
    @SerializedName(value="none", alternate={"none_of"})
    private Set<String> none_of;

    public static DependencyData of(List<String> dependencies) {
        return DependencyData.builder().dependencies(Set.copyOf(dependencies)).build();
    }

    public static DependencyData empty() {
        return DependencyData.builder().build();
    }

    public Set<String> getDependencies() {
        return this.safe(this.dependencies);
    }

    private Set<String> safe(@Nullable Set<String> elements) {
        return Objects.requireNonNullElseGet(elements, Collections::emptySet);
    }

    public Set<String> getAny_of() {
        return this.safe(this.any_of);
    }

    public Set<String> getNone_of() {
        return this.safe(this.none_of);
    }

    public boolean isEmpty() {
        return this.getDependencies().isEmpty() && this.getAny_of().isEmpty() && this.getNone_of().isEmpty();
    }

    private static Set<String> $default$dependencies() {
        return Collections.emptySet();
    }

    private static Set<String> $default$any_of() {
        return Collections.emptySet();
    }

    private static Set<String> $default$none_of() {
        return Collections.emptySet();
    }

    DependencyData(Set<String> dependencies, Set<String> any_of, Set<String> none_of) {
        this.dependencies = dependencies;
        this.any_of = any_of;
        this.none_of = none_of;
    }

    public static DependencyDataBuilder builder() {
        return new DependencyDataBuilder();
    }

    public DependencyDataBuilder toBuilder() {
        return new DependencyDataBuilder().dependencies(this.dependencies).any_of(this.any_of).none_of(this.none_of);
    }

    public static class DependencyDataBuilder {
        private boolean dependencies$set;
        private Set<String> dependencies$value;
        private boolean any_of$set;
        private Set<String> any_of$value;
        private boolean none_of$set;
        private Set<String> none_of$value;

        DependencyDataBuilder() {
        }

        public DependencyDataBuilder dependencies(Set<String> dependencies) {
            this.dependencies$value = dependencies;
            this.dependencies$set = true;
            return this;
        }

        public DependencyDataBuilder any_of(Set<String> any_of) {
            this.any_of$value = any_of;
            this.any_of$set = true;
            return this;
        }

        public DependencyDataBuilder none_of(Set<String> none_of) {
            this.none_of$value = none_of;
            this.none_of$set = true;
            return this;
        }

        public DependencyData build() {
            Set<String> dependencies$value = this.dependencies$value;
            if (!this.dependencies$set) {
                dependencies$value = DependencyData.$default$dependencies();
            }
            Set<String> any_of$value = this.any_of$value;
            if (!this.any_of$set) {
                any_of$value = DependencyData.$default$any_of();
            }
            Set<String> none_of$value = this.none_of$value;
            if (!this.none_of$set) {
                none_of$value = DependencyData.$default$none_of();
            }
            return new DependencyData(dependencies$value, any_of$value, none_of$value);
        }

        public String toString() {
            return "DependencyData.DependencyDataBuilder(dependencies$value=" + this.dependencies$value + ", any_of$value=" + this.any_of$value + ", none_of$value=" + this.none_of$value + ")";
        }
    }

    public static class DependencyDataDeserializer
    implements JsonDeserializer<DependencyData> {
        public DependencyData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonArray()) {
                ArrayList<String> dependenciesList = new ArrayList<String>();
                for (JsonElement element : json.getAsJsonArray()) {
                    dependenciesList.add(element.getAsString());
                }
                return DependencyData.of(dependenciesList);
            }
            if (json.isJsonObject()) {
                return (DependencyData)new Gson().fromJson(json, DependencyData.class);
            }
            throw new JsonParseException("Unsupported type for dependencies field");
        }
    }
}

