/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource.data.v2.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ModelEntryData;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class ModelData {
    @Nullable
    @SerializedName(value="target", alternate={"criteria", "predicate", "predicates"})
    private List<JsonElement> predicate;
    private int order;
    @SerializedName(value="modelType", alternate={"type"})
    @Nullable
    private String modelType;
    @Nullable
    private String template;
    @Nullable
    private String name;
    @Nullable
    private List<ModelEntryData> variants;
    @Nullable
    private List<Float> offset;
    @Nullable
    private String palette;
    @Nullable
    @SerializedName(value="children", alternate={"textures"})
    private List<ModelData> children;
    @Nullable
    private String texture;
    @Nullable
    @SerializedName(value="display_overrides", alternate={"display"})
    private JsonObject displayOverrides;
    @Nullable
    @SerializedName(value="parent")
    private String parent;
    @Nullable
    private Integer resolution;

    public List<JsonElement> getPredicates() {
        return Objects.requireNonNullElse(this.predicate, Collections.emptyList());
    }

    public String getModelType() {
        return Objects.requireNonNullElse(this.modelType, Identifiers.EMPTY_IDENTIFIER);
    }

    public String getTemplate() {
        return Objects.requireNonNullElse(this.template, Identifiers.EMPTY_IDENTIFIER);
    }

    public String getName() {
        return Objects.requireNonNullElse(this.name, Identifiers.EMPTY_IDENTIFIER);
    }

    public int order() {
        return this.order;
    }

    public List<ModelEntryData> getVariants() {
        return Objects.requireNonNullElse(this.variants, Collections.emptyList());
    }

    public List<Float> getOffset() {
        return Objects.requireNonNullElse(this.offset, Collections.emptyList());
    }

    public Optional<JsonObject> displayOverrides() {
        return Optional.ofNullable(this.displayOverrides);
    }

    @NotNull
    public Integer getResolution() {
        return Objects.requireNonNullElse(this.resolution, 16);
    }

    public String getPalette() {
        return Objects.requireNonNullElse(this.palette, Identifiers.EMPTY_IDENTIFIER);
    }

    @NotNull
    public List<ModelData> getChildren() {
        return Objects.requireNonNullElse(this.children, Collections.emptyList());
    }

    @NotNull
    public Optional<String> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @NotNull
    public String getTexture() {
        return Objects.requireNonNullElse(this.texture, Identifiers.EMPTY_IDENTIFIER);
    }

    private static List<JsonElement> $default$predicate() {
        return Collections.emptyList();
    }

    private static int $default$order() {
        return 0;
    }

    private static String $default$modelType() {
        return Identifiers.EMPTY_IDENTIFIER;
    }

    private static String $default$template() {
        return Identifiers.EMPTY_IDENTIFIER;
    }

    private static String $default$name() {
        return Identifiers.EMPTY_IDENTIFIER;
    }

    private static List<ModelEntryData> $default$variants() {
        return Collections.emptyList();
    }

    private static List<Float> $default$offset() {
        return Collections.emptyList();
    }

    private static String $default$palette() {
        return Identifiers.EMPTY_IDENTIFIER;
    }

    private static List<ModelData> $default$children() {
        return Collections.emptyList();
    }

    private static String $default$texture() {
        return Identifiers.EMPTY_IDENTIFIER;
    }

    private static Integer $default$resolution() {
        return 16;
    }

    ModelData(@Nullable List<JsonElement> predicate, int order, @Nullable String modelType, @Nullable String template, @Nullable String name, @Nullable List<ModelEntryData> variants, @Nullable List<Float> offset, @Nullable String palette, @Nullable List<ModelData> children, @Nullable String texture, @Nullable JsonObject displayOverrides, @Nullable String parent, @Nullable Integer resolution) {
        this.predicate = predicate;
        this.order = order;
        this.modelType = modelType;
        this.template = template;
        this.name = name;
        this.variants = variants;
        this.offset = offset;
        this.palette = palette;
        this.children = children;
        this.texture = texture;
        this.displayOverrides = displayOverrides;
        this.parent = parent;
        this.resolution = resolution;
    }

    public static ModelDataBuilder builder() {
        return new ModelDataBuilder();
    }

    public ModelDataBuilder toBuilder() {
        return new ModelDataBuilder().predicate(this.predicate).order(this.order).modelType(this.modelType).template(this.template).name(this.name).variants(this.variants).offset(this.offset).palette(this.palette).children(this.children).texture(this.texture).displayOverrides(this.displayOverrides).parent(this.parent).resolution(this.resolution);
    }

    public static class ModelDataBuilder {
        private boolean predicate$set;
        private List<JsonElement> predicate$value;
        private boolean order$set;
        private int order$value;
        private boolean modelType$set;
        private String modelType$value;
        private boolean template$set;
        private String template$value;
        private boolean name$set;
        private String name$value;
        private boolean variants$set;
        private List<ModelEntryData> variants$value;
        private boolean offset$set;
        private List<Float> offset$value;
        private boolean palette$set;
        private String palette$value;
        private boolean children$set;
        private List<ModelData> children$value;
        private boolean texture$set;
        private String texture$value;
        private JsonObject displayOverrides;
        private String parent;
        private boolean resolution$set;
        private Integer resolution$value;

        ModelDataBuilder() {
        }

        public ModelDataBuilder predicate(@Nullable List<JsonElement> predicate) {
            this.predicate$value = predicate;
            this.predicate$set = true;
            return this;
        }

        public ModelDataBuilder order(int order) {
            this.order$value = order;
            this.order$set = true;
            return this;
        }

        public ModelDataBuilder modelType(@Nullable String modelType) {
            this.modelType$value = modelType;
            this.modelType$set = true;
            return this;
        }

        public ModelDataBuilder template(@Nullable String template) {
            this.template$value = template;
            this.template$set = true;
            return this;
        }

        public ModelDataBuilder name(@Nullable String name) {
            this.name$value = name;
            this.name$set = true;
            return this;
        }

        public ModelDataBuilder variants(@Nullable List<ModelEntryData> variants) {
            this.variants$value = variants;
            this.variants$set = true;
            return this;
        }

        public ModelDataBuilder offset(@Nullable List<Float> offset) {
            this.offset$value = offset;
            this.offset$set = true;
            return this;
        }

        public ModelDataBuilder palette(@Nullable String palette) {
            this.palette$value = palette;
            this.palette$set = true;
            return this;
        }

        public ModelDataBuilder children(@Nullable List<ModelData> children) {
            this.children$value = children;
            this.children$set = true;
            return this;
        }

        public ModelDataBuilder texture(@Nullable String texture) {
            this.texture$value = texture;
            this.texture$set = true;
            return this;
        }

        public ModelDataBuilder displayOverrides(@Nullable JsonObject displayOverrides) {
            this.displayOverrides = displayOverrides;
            return this;
        }

        public ModelDataBuilder parent(@Nullable String parent) {
            this.parent = parent;
            return this;
        }

        public ModelDataBuilder resolution(@Nullable Integer resolution) {
            this.resolution$value = resolution;
            this.resolution$set = true;
            return this;
        }

        public ModelData build() {
            List<JsonElement> predicate$value = this.predicate$value;
            if (!this.predicate$set) {
                predicate$value = ModelData.$default$predicate();
            }
            int order$value = this.order$value;
            if (!this.order$set) {
                order$value = ModelData.$default$order();
            }
            String modelType$value = this.modelType$value;
            if (!this.modelType$set) {
                modelType$value = ModelData.$default$modelType();
            }
            String template$value = this.template$value;
            if (!this.template$set) {
                template$value = ModelData.$default$template();
            }
            String name$value = this.name$value;
            if (!this.name$set) {
                name$value = ModelData.$default$name();
            }
            List<ModelEntryData> variants$value = this.variants$value;
            if (!this.variants$set) {
                variants$value = ModelData.$default$variants();
            }
            List<Float> offset$value = this.offset$value;
            if (!this.offset$set) {
                offset$value = ModelData.$default$offset();
            }
            String palette$value = this.palette$value;
            if (!this.palette$set) {
                palette$value = ModelData.$default$palette();
            }
            List<ModelData> children$value = this.children$value;
            if (!this.children$set) {
                children$value = ModelData.$default$children();
            }
            String texture$value = this.texture$value;
            if (!this.texture$set) {
                texture$value = ModelData.$default$texture();
            }
            Integer resolution$value = this.resolution$value;
            if (!this.resolution$set) {
                resolution$value = ModelData.$default$resolution();
            }
            return new ModelData(predicate$value, order$value, modelType$value, template$value, name$value, variants$value, offset$value, palette$value, children$value, texture$value, this.displayOverrides, this.parent, resolution$value);
        }

        public String toString() {
            return "ModelData.ModelDataBuilder(predicate$value=" + this.predicate$value + ", order$value=" + this.order$value + ", modelType$value=" + this.modelType$value + ", template$value=" + this.template$value + ", name$value=" + this.name$value + ", variants$value=" + this.variants$value + ", offset$value=" + this.offset$value + ", palette$value=" + this.palette$value + ", children$value=" + this.children$value + ", texture$value=" + this.texture$value + ", displayOverrides=" + this.displayOverrides + ", parent=" + this.parent + ", resolution$value=" + this.resolution$value + ")";
        }
    }
}

