/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource.data.v2.data;

import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ModelData;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class ModelEntryData {
    @SerializedName(value="target", alternate={"predicate", "criteria", "predicates"})
    private List<JsonElement> predicates;
    @Nullable
    private String template;
    @Nullable
    private String palette;
    @Nullable
    private List<Float> offset;
    @Nullable
    private Integer resolution;
    @Nullable
    @SerializedName(value="children", alternate={"textures"})
    private List<ModelData> children;
    @Nullable
    private String texture;

    @NotNull
    public List<Float> getOffset() {
        return Objects.requireNonNullElse(this.offset, Collections.emptyList());
    }

    @NotNull
    public Integer getResolution() {
        return Objects.requireNonNullElse(this.resolution, 16);
    }

    @NotNull
    public List<JsonElement> getTarget() {
        return this.predicates;
    }

    @NotNull
    public String getTemplate() {
        return Objects.requireNonNullElse(this.template, Identifiers.EMPTY_IDENTIFIER);
    }

    @NotNull
    public String getPalette() {
        return Objects.requireNonNullElse(this.palette, Identifiers.EMPTY_IDENTIFIER);
    }

    @NotNull
    public List<ModelData> getChildren() {
        return Objects.requireNonNullElse(this.children, Collections.emptyList());
    }

    @NotNull
    public String getTexture() {
        return Objects.requireNonNullElse(this.texture, Identifiers.EMPTY_IDENTIFIER);
    }

    private static List<Float> $default$offset() {
        return Collections.emptyList();
    }

    private static Integer $default$resolution() {
        return 16;
    }

    private static List<ModelData> $default$children() {
        return Collections.emptyList();
    }

    private static String $default$texture() {
        return Identifiers.EMPTY_IDENTIFIER;
    }

    ModelEntryData(List<JsonElement> predicates, @Nullable String template, @Nullable String palette, @Nullable List<Float> offset, @Nullable Integer resolution, @Nullable List<ModelData> children, @Nullable String texture) {
        this.predicates = predicates;
        this.template = template;
        this.palette = palette;
        this.offset = offset;
        this.resolution = resolution;
        this.children = children;
        this.texture = texture;
    }

    public static ModelEntryDataBuilder builder() {
        return new ModelEntryDataBuilder();
    }

    public static class ModelEntryDataBuilder {
        private List<JsonElement> predicates;
        private String template;
        private String palette;
        private boolean offset$set;
        private List<Float> offset$value;
        private boolean resolution$set;
        private Integer resolution$value;
        private boolean children$set;
        private List<ModelData> children$value;
        private boolean texture$set;
        private String texture$value;

        ModelEntryDataBuilder() {
        }

        public ModelEntryDataBuilder predicates(List<JsonElement> predicates) {
            this.predicates = predicates;
            return this;
        }

        public ModelEntryDataBuilder template(@Nullable String template) {
            this.template = template;
            return this;
        }

        public ModelEntryDataBuilder palette(@Nullable String palette) {
            this.palette = palette;
            return this;
        }

        public ModelEntryDataBuilder offset(@Nullable List<Float> offset) {
            this.offset$value = offset;
            this.offset$set = true;
            return this;
        }

        public ModelEntryDataBuilder resolution(@Nullable Integer resolution) {
            this.resolution$value = resolution;
            this.resolution$set = true;
            return this;
        }

        public ModelEntryDataBuilder children(@Nullable List<ModelData> children) {
            this.children$value = children;
            this.children$set = true;
            return this;
        }

        public ModelEntryDataBuilder texture(@Nullable String texture) {
            this.texture$value = texture;
            this.texture$set = true;
            return this;
        }

        public ModelEntryData build() {
            List<Float> offset$value = this.offset$value;
            if (!this.offset$set) {
                offset$value = ModelEntryData.$default$offset();
            }
            Integer resolution$value = this.resolution$value;
            if (!this.resolution$set) {
                resolution$value = ModelEntryData.$default$resolution();
            }
            List<ModelData> children$value = this.children$value;
            if (!this.children$set) {
                children$value = ModelEntryData.$default$children();
            }
            String texture$value = this.texture$value;
            if (!this.texture$set) {
                texture$value = ModelEntryData.$default$texture();
            }
            return new ModelEntryData(this.predicates, this.template, this.palette, offset$value, resolution$value, children$value, texture$value);
        }

        public String toString() {
            return "ModelEntryData.ModelEntryDataBuilder(predicates=" + this.predicates + ", template=" + this.template + ", palette=" + this.palette + ", offset$value=" + this.offset$value + ", resolution$value=" + this.resolution$value + ", children$value=" + this.children$value + ", texture$value=" + this.texture$value + ")";
        }
    }
}

