/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource.data.v2.data;

import com.google.gson.annotations.SerializedName;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.IngredientData;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RecipeData {
    private final List<IngredientData> ingredients;
    @SerializedName(value="crafting_type")
    private final String craftingType;
    private final int count;
    private String target;

    public List<IngredientData> ingredients() {
        return Objects.requireNonNullElse(this.ingredients, Collections.emptyList());
    }

    public String type() {
        return Objects.requireNonNullElse(this.craftingType, Identifiers.EMPTY_IDENTIFIER);
    }

    public String target() {
        return Objects.requireNonNullElse(this.target, Identifiers.EMPTY_IDENTIFIER);
    }

    public int count() {
        if (this.count == 0) {
            return 1;
        }
        return this.count;
    }

    RecipeData(List<IngredientData> ingredients, String craftingType, int count, String target) {
        this.ingredients = ingredients;
        this.craftingType = craftingType;
        this.count = count;
        this.target = target;
    }

    public static RecipeDataBuilder builder() {
        return new RecipeDataBuilder();
    }

    public RecipeDataBuilder toBuilder() {
        return new RecipeDataBuilder().ingredients(this.ingredients).craftingType(this.craftingType).count(this.count).target(this.target);
    }

    public static class RecipeDataBuilder {
        private List<IngredientData> ingredients;
        private String craftingType;
        private int count;
        private String target;

        RecipeDataBuilder() {
        }

        public RecipeDataBuilder ingredients(List<IngredientData> ingredients) {
            this.ingredients = ingredients;
            return this;
        }

        public RecipeDataBuilder craftingType(String craftingType) {
            this.craftingType = craftingType;
            return this;
        }

        public RecipeDataBuilder count(int count) {
            this.count = count;
            return this;
        }

        public RecipeDataBuilder target(String target) {
            this.target = target;
            return this;
        }

        public RecipeData build() {
            return new RecipeData(this.ingredients, this.craftingType, this.count, this.target);
        }

        public String toString() {
            return "RecipeData.RecipeDataBuilder(ingredients=" + this.ingredients + ", craftingType=" + this.craftingType + ", count=" + this.count + ", target=" + this.target + ")";
        }
    }
}

