/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource.data.v2.factory;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.DataResource;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ResourceType;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.TypeData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.namedElement;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class TypeFactory {
    public static List<TypeData> convert(List<DataResource> resources) {
        return new TypeFactory().convertJsonToData(resources);
    }

    public List<TypeData> convertJsonToData(List<DataResource> resources) {
        return resources.stream().filter(resource -> resource.resourceType() == ResourceType.TYPE_DEFINITION).map(this::handleTypeResource).flatMap(Collection::stream).toList();
    }

    public List<TypeData> handleTypeResource(DataResource type) {
        String name = type.name();
        if (name.equals(Identifiers.EMPTY_IDENTIFIER)) {
            return Collections.emptyList();
        }
        TypeData data = type.parent().equals(Identifiers.EMPTY_IDENTIFIER) ? new TypeData(name, Optional.empty(), Collections.emptyList()) : new TypeData(name, Optional.of(type.parent()), Collections.emptyList());
        if (!type.children().isEmpty()) {
            return ImmutableList.builder().add((Object)data).addAll(this.createChildrenResources(type.children(), data.name())).build();
        }
        return List.of(data);
    }

    public List<TypeData> createChildrenResources(List<namedElement> children, String parent) {
        return children.stream().map(child -> new TypeData(child.name, Optional.of(parent), Collections.emptyList())).toList();
    }
}

