/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource.data.v2.loading;

import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.context.Context;
import com.sigmundgranaas.forgero.core.resource.data.PropertyPojo;
import com.sigmundgranaas.forgero.core.resource.data.deserializer.AttributeGroupDeserializer;
import com.sigmundgranaas.forgero.core.resource.data.deserializer.ContextDeserializer;
import com.sigmundgranaas.forgero.core.resource.data.v2.DataResourceProvider;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.ContextData;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.DataResource;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.DependencyData;
import com.sigmundgranaas.forgero.core.util.loader.ClassLoader;
import com.sigmundgranaas.forgero.core.util.loader.InputStreamLoader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Optional;

public class FileResourceProvider
implements DataResourceProvider {
    private final String path;
    private final InputStreamLoader streamLoader;

    public FileResourceProvider(String path, InputStreamLoader streamLoader) {
        this.path = path;
        this.streamLoader = streamLoader;
    }

    public FileResourceProvider(String path) {
        this.path = path;
        this.streamLoader = new ClassLoader();
    }

    @Override
    public Optional<DataResource> get() {
        Optional<InputStream> optDataStream = this.streamLoader.load(this.path);
        if (optDataStream.isPresent()) {
            try {
                InputStream stream = optDataStream.get();
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream));
                ContextData context = this.createContextFromPath(this.path);
                GsonBuilder builder = new GsonBuilder();
                builder.registerTypeAdapter(DependencyData.class, (Object)new DependencyData.DependencyDataDeserializer());
                builder.registerTypeAdapter(new TypeToken<List<PropertyPojo.Attribute>>(){}.getType(), (Object)new AttributeGroupDeserializer());
                builder.registerTypeAdapter(new TypeToken<Context>(){}.getType(), (Object)new ContextDeserializer());
                DataResource gson = (DataResource)builder.create().fromJson(reader, DataResource.class);
                if (gson != null) {
                    DataResource resource = gson.toBuilder().context(context).build();
                    if (resource == null) {
                        Forgero.LOGGER.error("Unable to load: {}, check if the file is valid", (Object)this.path);
                    }
                    return Optional.ofNullable(resource);
                }
                return Optional.empty();
            }
            catch (JsonParseException e) {
                Forgero.LOGGER.error("Unable to parse: {}, check if the file is valid", (Object)this.path);
                Forgero.LOGGER.error((Object)e);
                return Optional.empty();
            }
        }
        Forgero.LOGGER.error("Unable to load: {}", (Object)this.path);
        return Optional.empty();
    }

    public ContextData createContextFromPath(String filePath) {
        ContextData.ContextDataBuilder builder = ContextData.builder();
        String[] elements = filePath.split("\\" + File.separator);
        if (elements.length == 1) {
            elements = filePath.split("/");
        }
        String fileName = elements[elements.length - 1];
        String folder = elements[elements.length - 2];
        String path = filePath.replace(fileName, "");
        return builder.fileName(fileName).folder(folder).path(path).build();
    }
}

