/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.resource.data.v2.loading;

import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.resource.data.v2.ResourceLocator;
import com.sigmundgranaas.forgero.core.util.loader.PathFinder;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class PathWalker
implements ResourceLocator {
    private PathFinder pathFinder;
    private Predicate<Path> contentFilter;
    private int depth;

    @Override
    public List<Path> locate(String location) {
        Optional<Path> rootPath = this.pathFinder.find(location);
        if (rootPath.isPresent()) {
            List<Path> list;
            block9: {
                Path path = rootPath.get();
                Stream<Path> filesStream = Files.walk(path, this.depth, new FileVisitOption[0]);
                try {
                    list = filesStream.filter(this.contentFilter).toList();
                    if (filesStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (filesStream != null) {
                            try {
                                filesStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Forgero.LOGGER.error("Unable to list files from {}", (Object)path.toString());
                        Forgero.LOGGER.error((Object)e);
                    }
                }
                filesStream.close();
            }
            return list;
        }
        Forgero.LOGGER.error("Unable to locate resources in {}, as the path could not be found", (Object)location);
        return Collections.emptyList();
    }

    private static PathFinder $default$pathFinder() {
        return path -> Optional.empty();
    }

    private static Predicate<Path> $default$contentFilter() {
        return path -> true;
    }

    private static int $default$depth() {
        return 5;
    }

    PathWalker(PathFinder pathFinder, Predicate<Path> contentFilter, int depth) {
        this.pathFinder = pathFinder;
        this.contentFilter = contentFilter;
        this.depth = depth;
    }

    public static PathWalkerBuilder builder() {
        return new PathWalkerBuilder();
    }

    public PathWalkerBuilder toBuilder() {
        return new PathWalkerBuilder().pathFinder(this.pathFinder).contentFilter(this.contentFilter).depth(this.depth);
    }

    public static class PathWalkerBuilder {
        private boolean pathFinder$set;
        private PathFinder pathFinder$value;
        private boolean contentFilter$set;
        private Predicate<Path> contentFilter$value;
        private boolean depth$set;
        private int depth$value;

        PathWalkerBuilder() {
        }

        public PathWalkerBuilder pathFinder(PathFinder pathFinder) {
            this.pathFinder$value = pathFinder;
            this.pathFinder$set = true;
            return this;
        }

        public PathWalkerBuilder contentFilter(Predicate<Path> contentFilter) {
            this.contentFilter$value = contentFilter;
            this.contentFilter$set = true;
            return this;
        }

        public PathWalkerBuilder depth(int depth) {
            this.depth$value = depth;
            this.depth$set = true;
            return this;
        }

        public PathWalker build() {
            PathFinder pathFinder$value = this.pathFinder$value;
            if (!this.pathFinder$set) {
                pathFinder$value = PathWalker.$default$pathFinder();
            }
            Predicate<Path> contentFilter$value = this.contentFilter$value;
            if (!this.contentFilter$set) {
                contentFilter$value = PathWalker.$default$contentFilter();
            }
            int depth$value = this.depth$value;
            if (!this.depth$set) {
                depth$value = PathWalker.$default$depth();
            }
            return new PathWalker(pathFinder$value, contentFilter$value, depth$value);
        }

        public String toString() {
            return "PathWalker.PathWalkerBuilder(pathFinder$value=" + this.pathFinder$value + ", contentFilter$value=" + this.contentFilter$value + ", depth$value=" + this.depth$value + ")";
        }
    }
}

