/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.soul;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class IdentifiableIntTracker {
    private final Map<String, Integer> idMap;

    public IdentifiableIntTracker() {
        this.idMap = new ConcurrentHashMap<String, Integer>();
    }

    public IdentifiableIntTracker(Map<String, Integer> idMap) {
        this.idMap = idMap;
    }

    public int getTotal() {
        return this.idMap.values().stream().reduce(0, Integer::sum);
    }

    public void add(String id) {
        this.add(id, 1);
    }

    public void add(String id, int amount) {
        if (this.idMap.containsKey(id)) {
            this.idMap.compute(id, (currentId, oldValue) -> Objects.requireNonNullElse(oldValue, 0) + amount);
        } else {
            this.idMap.put(id, amount);
        }
    }

    public int getValueFor(String id) {
        return this.idMap.getOrDefault(id, 0);
    }

    public Map<String, Integer> toMap() {
        return Map.copyOf(this.idMap);
    }
}

