/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.soul;

import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.soul.LevelManager;
import com.sigmundgranaas.forgero.core.soul.PropertyLevelProvider;
import com.sigmundgranaas.forgero.core.soul.SoulLevelPropertyHandler;
import com.sigmundgranaas.forgero.core.soul.SoulSource;
import com.sigmundgranaas.forgero.core.soul.SoulStatToAttributes;
import com.sigmundgranaas.forgero.core.soul.StatTracker;
import com.sigmundgranaas.forgero.core.state.Identifiable;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class Soul
implements Identifiable,
PropertyContainer {
    private final SoulSource soulSource;
    private final StatTracker tracker;
    private final int level;
    private final int xpTarget;
    private final SoulLevelPropertyHandler levelPropertyHandler;
    private float xp;

    public Soul() {
        this.soulSource = new SoulSource("minecraft:zombie", "zombie");
        this.xp = 0.0f;
        this.level = 1;
        this.xpTarget = new LevelManager().getXpForLevel(this.level + 1);
        this.tracker = new StatTracker();
        this.levelPropertyHandler = new SoulLevelPropertyHandler(new HashMap<String, PropertyLevelProvider>());
    }

    public Soul(int level, float xp, SoulSource source, StatTracker tracker, SoulLevelPropertyHandler levelPropertyHandler) {
        this.soulSource = source;
        this.xp = xp;
        this.level = level;
        this.xpTarget = new LevelManager().getXpForLevel(level + 1);
        this.tracker = tracker;
        this.levelPropertyHandler = levelPropertyHandler;
    }

    public Soul(SoulSource source, SoulLevelPropertyHandler levelPropertyHandler) {
        this.soulSource = source;
        this.xp = 0.0f;
        this.level = 1;
        this.xpTarget = new LevelManager().getXpForLevel(this.level + 1);
        this.tracker = new StatTracker();
        this.levelPropertyHandler = levelPropertyHandler;
    }

    @Override
    public String name() {
        return this.soulSource.name();
    }

    @Override
    public String nameSpace() {
        return this.soulSource.nameSpace();
    }

    @Override
    public String identifier() {
        return this.soulSource.identifier();
    }

    public float getXp() {
        return this.xp;
    }

    public Soul addXp(float xp) {
        this.xp += xp;
        return this.tryLevelUp();
    }

    public int getLevel() {
        return this.level;
    }

    public Soul tryLevelUp() {
        if (this.xp >= (float)this.xpTarget) {
            float remainingXp = this.xp - (float)this.xpTarget;
            int level = this.level + 1;
            Soul leveledUp = new Soul(level, remainingXp, this.soulSource, this.tracker, this.levelPropertyHandler);
            return leveledUp.tryLevelUp();
        }
        return this;
    }

    public int getXpTarget() {
        return this.xpTarget;
    }

    public void trackBlock(String id, int i) {
        this.tracker.trackBlock(id, i);
    }

    public void trackMob(String id, int i) {
        this.tracker.trackMob(id, i);
    }

    public StatTracker tracker() {
        return this.tracker;
    }

    @Override
    @NotNull
    public List<Property> getRootProperties() {
        List<Object> levelProps = this.level == 1 ? Collections.emptyList() : this.levelPropertyHandler.apply(this.level - 1, this.soulSource.identifier());
        List<Property> trackerProps = new SoulStatToAttributes(this.tracker).getRootProperties();
        return Stream.of(levelProps, trackerProps).flatMap(Collection::stream).toList();
    }

    @Override
    @NotNull
    public List<Property> getRootProperties(Matchable target, MatchContext context) {
        return this.getRootProperties();
    }
}

