/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.soul;

import com.sigmundgranaas.forgero.core.model.match.PredicateFactory;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.attribute.AttributeBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.FeatureRegistry;
import com.sigmundgranaas.forgero.core.resource.data.PropertyPojo;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.SoulLevelPropertyData;
import com.sigmundgranaas.forgero.core.soul.PropertyLevelProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SoulLevelPropertyDataProcessor
implements PropertyLevelProvider {
    private final SoulLevelPropertyData data;

    public SoulLevelPropertyDataProcessor(SoulLevelPropertyData data) {
        SoulLevelPropertyData.SoulLevelPropertyDataBuilder newDataBuilder = SoulLevelPropertyData.builder();
        if (data.getProperties() != null) {
            PropertyPojo props = new PropertyPojo();
            props.features = Objects.requireNonNullElse(data.getProperties().features, Collections.emptyList());
            props.setAttributes(Objects.requireNonNullElse(data.getProperties().getAttributes(), Collections.emptyList()));
            newDataBuilder.properties(props);
        }
        this.data = newDataBuilder.build();
    }

    public String target() {
        return this.data.getId();
    }

    @Override
    public List<Property> apply(Integer level) {
        List attributes = this.data.getProperties().getAttributes().stream().map(attribute -> AttributeBuilder.createAttributeBuilder(attribute, new PredicateFactory())).map(builder -> builder.applyLevel(level)).map(AttributeBuilder::build).collect(Collectors.toList());
        List features = this.data.getProperties().features.stream().map(FeatureRegistry::of).flatMap(Optional::stream).collect(Collectors.toList());
        return Stream.of(attributes, features).flatMap(Collection::stream).toList();
    }
}

