/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.soul;

import com.sigmundgranaas.forgero.core.property.CalculationOrder;
import com.sigmundgranaas.forgero.core.property.NumericOperation;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.attribute.AttributeBuilder;
import com.sigmundgranaas.forgero.core.soul.StatTracker;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class SoulStatToAttributes
implements PropertyContainer {
    private final StatTracker tracker;

    public SoulStatToAttributes(StatTracker tracker) {
        this.tracker = tracker;
    }

    @Override
    @NotNull
    public List<Property> getRootProperties() {
        return Stream.of(this.mobAttributes(), this.blockAttributes()).flatMap(Collection::stream).toList();
    }

    @Override
    @NotNull
    public List<Property> getRootProperties(Matchable target, MatchContext context) {
        return this.getRootProperties();
    }

    private List<Property> blockAttributes() {
        return this.tracker.blocks().toMap().entrySet().stream().map(entry -> this.blockPercentage((Integer)entry.getValue(), (String)entry.getKey())).flatMap(Optional::stream).toList();
    }

    private Optional<Property> blockPercentage(int amount, String targetBlock) {
        int percent = amount / 1000;
        if (percent == 0) {
            return Optional.empty();
        }
        return Optional.of(new AttributeBuilder("MINING_SPEED").applyOrder(CalculationOrder.MIDDLE).applyOperation(NumericOperation.MULTIPLICATION).applyValue(1.0f + (float)percent / 100.0f).applyPredicate(Matchable.DEFAULT_TRUE).build());
    }

    private Optional<Property> mobPercentage(int amount, String targetBlock) {
        int percent = amount / 100;
        if (percent == 0) {
            return Optional.empty();
        }
        return Optional.of(new AttributeBuilder("ATTACK_DAMAGE").applyOrder(CalculationOrder.MIDDLE).applyOperation(NumericOperation.MULTIPLICATION).applyValue(1.0f + (float)percent / 100.0f).applyPredicate(Matchable.DEFAULT_TRUE).build());
    }

    private List<Property> mobAttributes() {
        return this.tracker.mobs().toMap().entrySet().stream().map(entry -> this.mobPercentage((Integer)entry.getValue(), (String)entry.getKey())).flatMap(Optional::stream).toList();
    }
}

