/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.state;

import com.sigmundgranaas.forgero.core.condition.ConditionContainer;
import com.sigmundgranaas.forgero.core.condition.Conditional;
import com.sigmundgranaas.forgero.core.customdata.DataContainer;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.Target;
import com.sigmundgranaas.forgero.core.state.IdentifiableContainer;
import com.sigmundgranaas.forgero.core.state.SimpleState;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.core.util.match.NameMatch;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ConditionedState
implements State,
Conditional<ConditionedState> {
    private final IdentifiableContainer id;
    private final ConditionContainer conditions;
    private final List<Property> properties;
    private final DataContainer customData;

    public ConditionedState(IdentifiableContainer id, ConditionContainer conditions, List<Property> properties, DataContainer customData) {
        this.id = id;
        this.conditions = conditions;
        this.properties = properties;
        this.customData = customData;
    }

    public static ConditionedState of(State state) {
        IdentifiableContainer id = new IdentifiableContainer(state.name(), state.nameSpace(), state.type());
        return new ConditionedState(id, Conditional.EMPTY, state.getRootProperties(), state.customData());
    }

    @Override
    public List<PropertyContainer> localConditions() {
        return this.conditions.localConditions();
    }

    @Override
    public ConditionedState applyCondition(PropertyContainer container) {
        return new ConditionedState(this.id, this.conditions.applyCondition(container), this.properties, this.customData);
    }

    @Override
    public ConditionedState removeCondition(String identifier) {
        return new ConditionedState(this.id, this.conditions.removeCondition(identifier), this.properties, this.customData);
    }

    @Override
    public String identifier() {
        return this.id.identifier();
    }

    @Override
    @NotNull
    public List<Property> getRootProperties() {
        return Stream.of(this.properties.stream().toList(), this.localConditions().stream().map(PropertyContainer::getRootProperties).flatMap(Collection::stream).toList()).flatMap(Collection::stream).toList();
    }

    @Override
    @NotNull
    public List<Property> getRootProperties(Matchable target, MatchContext context) {
        return Stream.of(this.properties.stream().toList(), this.localConditions().stream().map(state -> state.getRootProperties(target, context)).flatMap(Collection::stream).toList()).flatMap(Collection::stream).toList();
    }

    @Override
    public String name() {
        return this.id.name();
    }

    @Override
    public String nameSpace() {
        return this.id.nameSpace();
    }

    @Override
    public Type type() {
        return this.id.type();
    }

    @Override
    public State strip() {
        return new SimpleState(this.name(), this.nameSpace(), this.type(), this.properties);
    }

    @Override
    public boolean test(Matchable match, MatchContext context) {
        if (match instanceof NameMatch) {
            NameMatch matcher = (NameMatch)match;
            return matcher.name().equals(this.id.name());
        }
        return this.id.type().test(match, context);
    }

    @Override
    public DataContainer customData(Target target) {
        return this.customData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionedState that = (ConditionedState)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.conditions, that.conditions) && Objects.equals(this.properties, that.properties) && Objects.equals(this.customData, that.customData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.conditions, this.customData);
    }
}

