/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.state;

import com.sigmundgranaas.forgero.core.customdata.DataContainer;
import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.Target;
import com.sigmundgranaas.forgero.core.property.attribute.AttributeBuilder;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class LeveledState
implements State {
    private final String name;
    private final String nameSpace;
    private final Type type;
    private List<Property> properties;
    private int level;

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String nameSpace() {
        return this.nameSpace;
    }

    @Override
    public Type type() {
        return this.type;
    }

    public int level() {
        return this.level;
    }

    @Override
    @NotNull
    public List<Property> getRootProperties() {
        return this.leveledProperties(this.properties);
    }

    @Override
    @NotNull
    public List<Property> getRootProperties(Matchable target, MatchContext context) {
        return this.applyProperty(target, context);
    }

    private List<Property> leveledProperties(List<Property> props) {
        List<Property> otherProperties = props.stream().filter(property -> !(property instanceof Attribute)).toList();
        List<Attribute> attributes = props.stream().filter(property -> property instanceof Attribute).map(Attribute.class::cast).map(attribute -> AttributeBuilder.createAttributeBuilderFromAttribute(attribute).applyLevel(this.level()).build()).toList();
        return Stream.of(otherProperties, attributes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<Property> applyProperty(Matchable target, MatchContext context) {
        return this.leveledProperties(this.properties).stream().filter(prop -> prop.applyCondition(target, context)).toList();
    }

    public LeveledState levelUp() {
        return this.toBuilder().level(this.level + 1).name(this.name).nameSpace(this.nameSpace).type(this.type).build();
    }

    public LeveledState setLevel(int level) {
        return this.toBuilder().level(level).name(this.name).nameSpace(this.nameSpace).type(this.type).build();
    }

    @Override
    public DataContainer customData(Target target) {
        return DataContainer.empty();
    }

    @Override
    public State strip() {
        return this;
    }

    private static List<Property> $default$properties() {
        return Collections.emptyList();
    }

    private static int $default$level() {
        return 1;
    }

    LeveledState(String name, String nameSpace, Type type, List<Property> properties, int level) {
        this.name = name;
        this.nameSpace = nameSpace;
        this.type = type;
        this.properties = properties;
        this.level = level;
    }

    public static LeveledStateBuilder builder() {
        return new LeveledStateBuilder();
    }

    public LeveledStateBuilder toBuilder() {
        return new LeveledStateBuilder().name(this.name).nameSpace(this.nameSpace).type(this.type).properties(this.properties).level(this.level);
    }

    public static class LeveledStateBuilder {
        private String name;
        private String nameSpace;
        private Type type;
        private boolean properties$set;
        private List<Property> properties$value;
        private boolean level$set;
        private int level$value;

        LeveledStateBuilder() {
        }

        public LeveledStateBuilder name(String name) {
            this.name = name;
            return this;
        }

        public LeveledStateBuilder nameSpace(String nameSpace) {
            this.nameSpace = nameSpace;
            return this;
        }

        public LeveledStateBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public LeveledStateBuilder properties(List<Property> properties) {
            this.properties$value = properties;
            this.properties$set = true;
            return this;
        }

        public LeveledStateBuilder level(int level) {
            this.level$value = level;
            this.level$set = true;
            return this;
        }

        public LeveledState build() {
            List<Property> properties$value = this.properties$value;
            if (!this.properties$set) {
                properties$value = LeveledState.$default$properties();
            }
            int level$value = this.level$value;
            if (!this.level$set) {
                level$value = LeveledState.$default$level();
            }
            return new LeveledState(this.name, this.nameSpace, this.type, properties$value, level$value);
        }

        public String toString() {
            return "LeveledState.LeveledStateBuilder(name=" + this.name + ", nameSpace=" + this.nameSpace + ", type=" + this.type + ", properties$value=" + this.properties$value + ", level$value=" + this.level$value + ")";
        }
    }
}

