/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.state;

import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.StateProvider;
import org.jetbrains.annotations.NotNull;

public class MutableStateProvider
implements StateProvider {
    @NotNull
    private State state;

    public MutableStateProvider(@NotNull State defaultState) {
        this.state = defaultState;
    }

    @Override
    public State get() {
        return this.state;
    }

    public StateProvider update(State update) {
        if (this.canUpdate(update)) {
            this.state = update;
        } else {
            Forgero.LOGGER.warn("Tried to update state: {}, with a new incompatible state: {}", (Object)this.state.identifier(), (Object)update.identifier());
        }
        return this;
    }

    public boolean canUpdate(State update) {
        return this.state.identifier().equals(update.identifier()) && this.state.type().typeName().equals(update.type().typeName());
    }
}

