/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.state;

import com.sigmundgranaas.forgero.core.condition.Conditional;
import com.sigmundgranaas.forgero.core.customdata.DataContainer;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.Target;
import com.sigmundgranaas.forgero.core.state.ConditionedState;
import com.sigmundgranaas.forgero.core.state.Ingredient;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.core.util.match.NameMatch;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class SimpleState
implements Ingredient,
Conditional<State> {
    private final String name;
    private final String nameSpace;
    private final Type type;
    private final List<Property> properties;
    private final DataContainer customData;

    public SimpleState(String name, Type type, List<Property> properties) {
        this.name = name;
        this.type = type;
        this.properties = properties;
        this.nameSpace = "forgero";
        this.customData = DataContainer.empty();
    }

    public SimpleState(String name, String nameSpace, Type type, List<Property> properties) {
        this.name = name;
        this.nameSpace = nameSpace;
        this.type = type;
        this.properties = properties;
        this.customData = DataContainer.empty();
    }

    public SimpleState(String name, String nameSpace, Type type, List<Property> properties, DataContainer custom) {
        this.name = name;
        this.nameSpace = nameSpace;
        this.type = type;
        this.properties = properties;
        this.customData = custom;
    }

    @Override
    @NotNull
    public List<Property> getRootProperties() {
        return this.properties;
    }

    @Override
    @NotNull
    public List<Property> getRootProperties(Matchable target, MatchContext context) {
        return this.getProperties();
    }

    @Override
    @NotNull
    public Type type() {
        return this.type;
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    public String nameSpace() {
        return this.nameSpace;
    }

    @Override
    public State strip() {
        return this;
    }

    @Override
    public boolean test(Matchable match, MatchContext context) {
        if (match instanceof NameMatch) {
            NameMatch matcher = (NameMatch)match;
            return matcher.name().equals(this.name);
        }
        return this.type.test(match, context);
    }

    @Override
    public List<PropertyContainer> localConditions() {
        return Collections.emptyList();
    }

    @Override
    public State applyCondition(PropertyContainer container) {
        return ConditionedState.of(this).applyCondition(container);
    }

    @Override
    public State removeCondition(String identifier) {
        return this;
    }

    @Override
    public DataContainer customData(Target target) {
        return this.customData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleState that = (SimpleState)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.nameSpace, that.nameSpace) && Objects.equals(this.type, that.type) && Objects.equals(this.properties, that.properties) && Objects.equals(this.customData, that.customData);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.nameSpace, this.type, this.identifier() + "_properties", this.customData);
    }

    public String toString() {
        return "SimpleState{name='" + this.name + "', nameSpace='" + this.nameSpace + "', type=" + this.type + ", properties=" + this.properties.stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]")) + ", customData=" + this.customData.toString() + "}";
    }
}

