/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.state;

import com.sigmundgranaas.forgero.core.customdata.DataContainer;
import com.sigmundgranaas.forgero.core.customdata.DataSupplier;
import com.sigmundgranaas.forgero.core.customdata.Visitable;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.state.CompositeIngredient;
import com.sigmundgranaas.forgero.core.state.Identifiable;
import com.sigmundgranaas.forgero.core.state.SimpleState;
import com.sigmundgranaas.forgero.core.state.Typed;
import com.sigmundgranaas.forgero.core.state.composite.Construct;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.core.util.match.NameMatch;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface State
extends PropertyContainer,
Matchable,
Identifiable,
Comparable<Object>,
Typed,
Visitable,
DataSupplier {
    public static State of(Construct construct) {
        return new CompositeIngredient(construct);
    }

    public static State of(String name, Type type, List<Property> properties) {
        return new SimpleState(name, type, properties);
    }

    public static State of(String name, String nameSpace, Type type, List<Property> properties) {
        return new SimpleState(name, nameSpace, type, properties);
    }

    public static State of(String name, String nameSpace, Type type, List<Property> properties, DataContainer custom) {
        return new SimpleState(name, nameSpace, type, properties, custom);
    }

    public State strip();

    default public boolean equals(State s) {
        return false;
    }

    @Override
    default public boolean test(Matchable match, MatchContext context) {
        if (match instanceof Type) {
            Type typeMatch = (Type)match;
            if (this.type().test(typeMatch, context)) {
                return true;
            }
        }
        if (match instanceof NameMatch) {
            NameMatch name = (NameMatch)match;
            return name.test(this, context);
        }
        return false;
    }

    @Override
    default public int compareTo(@NotNull Object o) {
        if (o instanceof State) {
            State state = (State)o;
            int compare = PropertyContainer.super.compareTo(state);
            if (compare == 0) {
                return this.name().compareTo(state.name());
            }
            return compare;
        }
        return 0;
    }
}

