/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.state.composite;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.IdentifiableContainer;
import com.sigmundgranaas.forgero.core.state.NameCompositor;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.SlotContainer;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.core.util.match.NameMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class BaseComposite
implements Composite {
    protected final SlotContainer slotContainer;
    protected final IdentifiableContainer id;

    protected BaseComposite(SlotContainer slotContainer, IdentifiableContainer id) {
        this.slotContainer = slotContainer;
        this.id = id;
    }

    @Override
    @NotNull
    public List<Property> applyProperty(Matchable target, MatchContext context) {
        MatchContext newContext = context.add(this.id.type());
        return this.compositeProperties(target, context);
    }

    @Override
    @NotNull
    public List<Property> getRootProperties() {
        return this.compositeProperties(Matchable.DEFAULT_TRUE, MatchContext.of());
    }

    @Override
    public List<Property> compositeProperties(Matchable target, MatchContext context) {
        List<Property> upgradeProps = this.slots().stream().map(state -> state.getRootProperties(target, context)).flatMap(Collection::stream).collect(Collectors.toList());
        return upgradeProps;
    }

    @Override
    public Optional<State> has(String id) {
        return this.components().stream().map(comp -> this.recursiveComponentHas((State)comp, id)).flatMap(Optional::stream).findFirst();
    }

    private Optional<State> recursiveComponentHas(State target, String id) {
        Composite comp;
        if (target.identifier().contains(id)) {
            return Optional.of(target);
        }
        if (target instanceof Composite && (comp = (Composite)target).has(id).isPresent()) {
            return comp.has(id);
        }
        return Optional.empty();
    }

    @Override
    public String name() {
        return this.id.name();
    }

    @Override
    public String identifier() {
        return this.id.identifier();
    }

    @Override
    public String nameSpace() {
        return this.id.nameSpace();
    }

    @Override
    public Type type() {
        return this.id.type();
    }

    @Override
    public boolean test(Matchable match, MatchContext context) {
        NameMatch name;
        if (match instanceof Type) {
            Type typeMatch = (Type)match;
            if (this.type().test(typeMatch, context)) {
                return true;
            }
        }
        return match instanceof NameMatch && (name = (NameMatch)match).test(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseComposite that = (BaseComposite)o;
        return Objects.equals(this.slotContainer, that.slotContainer) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.slotContainer, this.id);
    }

    @Override
    public ImmutableList<State> upgrades() {
        return this.slotContainer.entries();
    }

    @Override
    public boolean canUpgrade(State state) {
        return this.slotContainer.canUpgrade(state);
    }

    @Override
    public List<Slot> slots() {
        return this.slotContainer.slots();
    }

    @Override
    public SlotContainer getSlotContainer() {
        return this.slotContainer;
    }

    public static abstract class BaseCompositeBuilder<B extends BaseCompositeBuilder<B>> {
        protected List<State> ingredientList;
        protected SlotContainer upgradeContainer;
        protected NameCompositor compositor = NameCompositor.of();
        protected Type type = Type.UNDEFINED;
        protected String name;
        protected String nameSpace = "forgero";

        public BaseCompositeBuilder() {
            this.ingredientList = new ArrayList<State>();
            this.upgradeContainer = SlotContainer.of(Collections.emptyList());
        }

        public B addIngredient(State ingredient) {
            this.ingredientList.add(ingredient);
            return (B)this;
        }

        public B addIngredients(List<State> ingredients) {
            this.ingredientList.addAll(ingredients);
            return (B)this;
        }

        public B addUpgrade(State upgrade) {
            this.upgradeContainer.set(upgrade);
            return (B)this;
        }

        public B addUpgrade(Slot upgrade) {
            this.upgradeContainer.set(upgrade);
            return (B)this;
        }

        public B addSlotContainer(SlotContainer container) {
            this.upgradeContainer = container;
            return (B)this;
        }

        public B addUpgrades(List<? extends Slot> upgrades) {
            upgrades.forEach(this.upgradeContainer::set);
            return (B)this;
        }

        public B addUpgrades(ImmutableList<State> upgrades) {
            upgrades.forEach(this.upgradeContainer::set);
            return (B)this;
        }

        public B type(Type type) {
            this.type = type;
            return (B)this;
        }

        public B name(String name) {
            this.name = name;
            return (B)this;
        }

        public B nameSpace(String nameSpace) {
            this.nameSpace = nameSpace;
            return (B)this;
        }

        public B id(String id) {
            String[] elements = id.split(":");
            if (elements.length == 2) {
                this.nameSpace = elements[0];
                this.name = elements[1];
            }
            return (B)this;
        }

        public B compositor(NameCompositor compositor) {
            this.compositor = compositor;
            return (B)this;
        }

        protected void compositeName() {
            if (this.name == null && !this.ingredientList.isEmpty()) {
                this.name = this.compositor.compositeName(this.ingredientList);
            }
        }

        public abstract State build();

        public List<State> getIngredientList() {
            return this.ingredientList;
        }

        public SlotContainer getUpgradeContainer() {
            return this.upgradeContainer;
        }

        public NameCompositor getCompositor() {
            return this.compositor;
        }

        public Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getNameSpace() {
            return this.nameSpace;
        }
    }
}

