/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.state.composite;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.context.Contexts;
import com.sigmundgranaas.forgero.core.customdata.DataContainer;
import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.CalculationOrder;
import com.sigmundgranaas.forgero.core.property.NumericOperation;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.Target;
import com.sigmundgranaas.forgero.core.property.attribute.AttributeBuilder;
import com.sigmundgranaas.forgero.core.property.attribute.Category;
import com.sigmundgranaas.forgero.core.property.attribute.TypeTarget;
import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.composite.BaseComposite;
import com.sigmundgranaas.forgero.core.state.composite.ConstructedState;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.SlotContainer;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.core.util.match.NameMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class Construct
implements Composite,
ConstructedState {
    private final List<State> ingredientList;
    private final SlotContainer upgrades;
    private final String name;
    private final String nameSpace;
    private final Type type;
    private int code = 0;

    protected Construct(List<State> ingredientList, SlotContainer upgrades, String name, Type type) {
        this.name = name;
        this.ingredientList = ingredientList;
        this.upgrades = upgrades;
        this.type = type;
        this.nameSpace = "forgero";
    }

    protected Construct(List<State> ingredientList, SlotContainer upgrades, String name, String nameSpace, Type type) {
        this.name = name;
        this.ingredientList = ingredientList;
        this.upgrades = upgrades;
        this.type = type;
        this.nameSpace = nameSpace;
    }

    public static ConstructBuilder builder() {
        return new ConstructBuilder();
    }

    public static ConstructBuilder builder(SlotContainer container) {
        return new ConstructBuilder(container);
    }

    @Override
    public SlotContainer getSlotContainer() {
        return this.upgrades;
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    public String nameSpace() {
        return this.nameSpace;
    }

    @Override
    @NotNull
    public Type type() {
        return this.type;
    }

    @Override
    @NotNull
    public List<Property> getRootProperties() {
        return this.compositeProperties(Matchable.DEFAULT_TRUE, MatchContext.of());
    }

    @Override
    @NotNull
    public List<Property> getRootProperties(Matchable target, MatchContext context) {
        return this.compositeProperties(target, context.add(this.type()));
    }

    @Override
    @NotNull
    public List<Property> applyProperty(Matchable target, MatchContext context) {
        MatchContext newTarget = context.add(this.type);
        return this.compositeProperties(target, newTarget);
    }

    @Override
    public List<Property> compositeProperties(Matchable target, MatchContext context) {
        List<Property> props = Stream.of(this.ingredients(), this.slots()).flatMap(Collection::stream).map(state -> state.getRootProperties(target, context)).flatMap(Collection::stream).filter(prop -> {
            Attribute attribute;
            return !(prop instanceof Attribute && (attribute = (Attribute)prop).getContext().test(Contexts.LOCAL));
        }).collect(Collectors.toList());
        List<Property> upgradeProps = this.ingredients().stream().map(slot -> slot.getRootProperties(target, context)).flatMap(Collection::stream).filter(this::filterAttribute).toList();
        List<Property> compositeAttributes = Property.stream(props).getAttributes().collect(Collectors.toMap(Object::toString, attribute -> attribute, (attribute1, attribute2) -> attribute1.getPriority() > attribute2.getPriority() ? attribute1 : attribute2)).values().stream().filter(attribute -> attribute.getContext().test(Contexts.COMPOSITE)).collect(Collectors.toList());
        ArrayList<Attribute> newValues = new ArrayList<Attribute>();
        Set types = compositeAttributes.stream().map(Property::type).collect(Collectors.toUnmodifiableSet());
        for (String type : types) {
            AttributeBuilder newBaseAttribute = new AttributeBuilder(type).applyOperation(NumericOperation.ADDITION).applyOrder(CalculationOrder.BASE);
            newBaseAttribute.applyValue(Property.stream(compositeAttributes).applyAttribute(type)).applyCategory(Category.UNDEFINED);
            Attribute attribute3 = newBaseAttribute.build();
            if (attribute3.getValue() == 0.0f || compositeAttributes.stream().filter(prop -> {
                Attribute attribute1;
                return prop instanceof Attribute && (attribute1 = (Attribute)prop).getAttributeType().equals(type);
            }).toList().size() <= 1) continue;
            newValues.add(newBaseAttribute.build());
        }
        ArrayList<Property> other = new ArrayList<Property>(props);
        compositeAttributes.forEach(other::remove);
        upgradeProps.forEach(other::remove);
        other.addAll(newValues);
        return other;
    }

    @Override
    public Optional<State> has(String id) {
        return this.components().stream().map(comp -> this.recursiveComponentHas((State)comp, id)).flatMap(Optional::stream).findFirst();
    }

    private Optional<State> recursiveComponentHas(State target, String id) {
        Composite comp;
        if (target.identifier().contains(id)) {
            return Optional.of(target);
        }
        if (target instanceof Composite && (comp = (Composite)target).has(id).isPresent()) {
            return comp.has(id);
        }
        return Optional.empty();
    }

    private boolean filterAttribute(Property property) {
        if (property instanceof Attribute) {
            Attribute attribute = (Attribute)property;
            return Category.UPGRADE_CATEGORIES.contains((Object)attribute.getCategory());
        }
        return false;
    }

    @Override
    public State strip() {
        ConstructBuilder builder = Construct.builder();
        this.parts().stream().map(State::strip).forEach(builder::addIngredient);
        builder.id(this.identifier());
        builder.type(this.type());
        builder.addSlotContainer(this.getSlotContainer().strip());
        return builder.build();
    }

    @Override
    public boolean test(Matchable match, MatchContext context) {
        if (match instanceof Type) {
            Type typeMatch = (Type)match;
            if (this.type().test(typeMatch, context)) {
                return true;
            }
            return this.ingredientList.stream().anyMatch(ingredient -> ingredient.test(match, context));
        }
        if (match instanceof NameMatch) {
            NameMatch name = (NameMatch)match;
            if (name.test(this, context)) {
                return true;
            }
            return this.ingredientList.stream().anyMatch(ingredient -> ingredient.test(name, context));
        }
        return false;
    }

    public List<State> ingredients() {
        return this.ingredientList;
    }

    @Override
    public Construct removeUpgrade(String id) {
        int i;
        if (this.upgrades().stream().anyMatch(state -> state.identifier().contains(id))) {
            List<Slot> originalSlots = this.slots().stream().filter(slot -> !slot.filled() || slot.get().isPresent() && !slot.get().get().identifier().contains(id)).toList();
            List<Slot> emptySlots = this.slots().stream().filter(slot -> slot.get().isPresent() && slot.get().get().identifier().contains(id)).map(Slot::empty).toList();
            return ((ConstructBuilder)((ConstructBuilder)((ConstructBuilder)((ConstructBuilder)((ConstructBuilder)Construct.builder().addIngredients(this.ingredients())).addUpgrades(originalSlots)).addUpgrades(emptySlots)).type(this.type())).id(this.identifier())).build();
        }
        for (i = 0; i < this.ingredientList.size(); ++i) {
            Composite compositeRemoved;
            Composite construct;
            State state2 = this.ingredientList.get(i);
            if (!(state2 instanceof Composite) || (construct = (Composite)state2) == (compositeRemoved = (Composite)construct.removeUpgrade(id))) continue;
            ArrayList<State> ingredients = new ArrayList<State>(this.ingredientList);
            ingredients.set(i, compositeRemoved);
            return ((ConstructBuilder)((ConstructBuilder)((ConstructBuilder)((ConstructBuilder)Construct.builder().addIngredients(ingredients)).addUpgrades(this.slots())).type(this.type())).id(this.identifier())).build();
        }
        for (i = 0; i < this.slots().size(); ++i) {
            Composite compositeRemoved;
            Composite construct;
            State ingredients;
            Slot slot2 = this.slots().get(i);
            if (!slot2.get().isPresent() || !((ingredients = slot2.get().get()) instanceof Composite) || (construct = (Composite)ingredients) == (compositeRemoved = (Composite)construct.removeUpgrade(id))) continue;
            ArrayList<Slot> slots = new ArrayList<Slot>(this.slots());
            slots.set(i, slot2.empty().fill(compositeRemoved, slot2.category()).orElse(slot2.empty()));
            return ((ConstructBuilder)((ConstructBuilder)((ConstructBuilder)((ConstructBuilder)Construct.builder().addIngredients(this.ingredients())).addUpgrades(slots)).type(this.type())).id(this.identifier())).build();
        }
        return this;
    }

    @Override
    public List<State> components() {
        return Stream.of(this.ingredients(), this.upgrades()).flatMap(Collection::stream).filter(state -> !state.name().contains("schematic")).toList();
    }

    @Override
    public Construct upgrade(State upgrade) {
        return ((ConstructBuilder)((ConstructBuilder)((ConstructBuilder)((ConstructBuilder)((ConstructBuilder)Construct.builder().addIngredients(this.ingredients())).addUpgrades(this.upgrades.slots())).addUpgrade(upgrade)).type(this.type())).id(this.identifier())).build();
    }

    public ConstructBuilder toBuilder() {
        return (ConstructBuilder)((ConstructBuilder)((ConstructBuilder)((ConstructBuilder)Construct.builder().addIngredients(this.ingredients().stream().map(ingredient -> {
            if (ingredient instanceof Composite) {
                Composite composite = (Composite)ingredient;
                return (State)composite.copy();
            }
            return ingredient;
        }).toList())).addSlotContainer(this.upgrades.copy())).type(this.type())).id(this.identifier());
    }

    @Override
    public ImmutableList<State> upgrades() {
        return ImmutableList.builder().addAll(this.upgrades.entries()).build();
    }

    @Override
    public List<Slot> slots() {
        return this.upgrades.slots();
    }

    @Override
    public boolean canUpgrade(State state) {
        return this.upgrades.canUpgrade(state);
    }

    @Override
    public List<State> parts() {
        return this.ingredientList;
    }

    @Override
    public Composite copy() {
        return this.toBuilder().build();
    }

    @Override
    public DataContainer customData(Target target) {
        Target combinedTarget = target.combineTarget(new TypeTarget(Set.of(this.type().typeName())));
        return this.components().stream().map(state -> state.customData(combinedTarget)).reduce(DataContainer.empty(), (dataContainer1, dataContainer2) -> DataContainer.transitiveMerge(dataContainer1, dataContainer2, combinedTarget));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Construct)) {
            return false;
        }
        Construct construct = (Construct)o;
        return Objects.equals(this.ingredientList, construct.ingredientList) && Objects.equals(this.upgrades, construct.upgrades) && Objects.equals(this.name, construct.name) && Objects.equals(this.nameSpace, construct.nameSpace) && Objects.equals(this.type, construct.type);
    }

    public int hashCode() {
        if (this.code == 0) {
            this.code = Objects.hash(this.ingredientList, this.upgrades, this.name, this.nameSpace, this.type);
        }
        return this.code;
    }

    public static class ConstructBuilder
    extends BaseComposite.BaseCompositeBuilder<ConstructBuilder> {
        public ConstructBuilder() {
            this.ingredientList = new ArrayList();
            this.upgradeContainer = SlotContainer.of(Collections.emptyList());
        }

        public ConstructBuilder(SlotContainer container) {
            this.ingredientList = new ArrayList();
            this.upgradeContainer = container;
        }

        @Override
        public Construct build() {
            if (this.name == null && !this.ingredientList.isEmpty()) {
                this.name = this.compositor.compositeName(this.ingredientList);
            }
            return new Construct(this.ingredientList, this.upgradeContainer, this.name, this.nameSpace, this.type);
        }
    }
}

