/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.state.composite;

import com.sigmundgranaas.forgero.core.context.Contexts;
import com.sigmundgranaas.forgero.core.customdata.DataContainer;
import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.Target;
import com.sigmundgranaas.forgero.core.property.attribute.TypeTarget;
import com.sigmundgranaas.forgero.core.property.v2.CompositePropertyProcessor;
import com.sigmundgranaas.forgero.core.property.v2.PredicateConvertedPropertyProcessor;
import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.IdentifiableContainer;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.composite.BaseComposite;
import com.sigmundgranaas.forgero.core.state.composite.ConstructedState;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.SlotContainer;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.core.util.match.NameMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ConstructedComposite
extends BaseComposite
implements ConstructedState {
    private final List<State> parts;

    protected ConstructedComposite(SlotContainer slotContainer, IdentifiableContainer id, List<State> parts) {
        super(slotContainer, id);
        this.parts = parts;
    }

    @Override
    public List<State> components() {
        return Stream.of(this.parts(), this.upgrades()).flatMap(Collection::stream).toList();
    }

    @Override
    public ConstructedComposite upgrade(State upgrade) {
        return ((ConstructBuilder)this.toBuilder().addUpgrade(upgrade)).build();
    }

    @Override
    @NotNull
    public List<Property> applyProperty(Matchable target, MatchContext context) {
        MatchContext newContext = context.add(this.id.type());
        return this.compositeProperties(target, newContext);
    }

    @Override
    @NotNull
    public List<Property> getRootProperties() {
        return this.compositeProperties(Matchable.DEFAULT_TRUE, MatchContext.of().add(this.id.type()));
    }

    @Override
    @NotNull
    public List<Property> getRootProperties(Matchable target, MatchContext context) {
        return this.compositeProperties(target, context.add(this.id.type()));
    }

    @Override
    public ConstructedComposite removeUpgrade(String id) {
        return this;
    }

    @Override
    public List<Property> compositeProperties(Matchable target, MatchContext context) {
        CompositePropertyProcessor propertyProcessor = new CompositePropertyProcessor();
        PredicateConvertedPropertyProcessor predicateProcessor = new PredicateConvertedPropertyProcessor();
        ArrayList<Property> props = new ArrayList<Property>(super.compositeProperties(target, context));
        List<Property> partProps = this.parts().stream().flatMap(part -> part.getProperties().stream().map(part::applySource)).toList();
        props.addAll(propertyProcessor.process(partProps, target, context));
        props.addAll(predicateProcessor.process(partProps, target, context));
        List<Property> otherProps = partProps.stream().filter(this::filterNormalProperties).toList();
        props.addAll(otherProps);
        return props;
    }

    private boolean filterNormalProperties(Property property) {
        if (property instanceof Attribute) {
            Attribute attribute = (Attribute)property;
            return attribute.getContext().test(Contexts.UNDEFINED);
        }
        return true;
    }

    @Override
    public List<State> parts() {
        return this.parts;
    }

    public ConstructBuilder toBuilder() {
        return (ConstructBuilder)((ConstructBuilder)((ConstructBuilder)((ConstructBuilder)ConstructBuilder.builder().addIngredients(this.parts().stream().map(part -> {
            if (part instanceof Composite) {
                Composite composite = (Composite)part;
                return (State)composite.copy();
            }
            return part;
        }).toList())).addSlotContainer(this.slotContainer.copy())).type(this.type())).id(this.identifier());
    }

    @Override
    public State strip() {
        ConstructBuilder builder = ConstructBuilder.builder();
        builder.addSlotContainer(this.getSlotContainer().strip());
        this.parts().stream().map(State::strip).forEach(builder::addIngredient);
        builder.type(this.type());
        builder.id(this.identifier());
        return builder.build();
    }

    @Override
    public boolean test(Matchable match, MatchContext context) {
        if (match instanceof Type) {
            Type typeMatch = (Type)match;
            if (this.type().test(typeMatch, context)) {
                return true;
            }
            return this.parts().stream().anyMatch(ingredient -> ingredient.test(match, context));
        }
        if (match instanceof NameMatch) {
            NameMatch name = (NameMatch)match;
            if (name.test(this, context)) {
                return true;
            }
            return this.parts().stream().anyMatch(ingredient -> ingredient.test(name, context));
        }
        return false;
    }

    @Override
    public ConstructedComposite copy() {
        return this.toBuilder().build();
    }

    @Override
    public DataContainer customData(Target target) {
        Target combinedTarget = target.combineTarget(new TypeTarget(Set.of(this.type().typeName())));
        return this.components().stream().map(state -> state.customData(combinedTarget)).reduce(DataContainer.empty(), (dataContainer1, dataContainer2) -> DataContainer.transitiveMerge(dataContainer1, dataContainer2, combinedTarget));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstructedComposite)) {
            return false;
        }
        ConstructedComposite that = (ConstructedComposite)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.parts, that.parts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.parts, super.hashCode());
    }

    public static class ConstructBuilder
    extends BaseComposite.BaseCompositeBuilder<ConstructBuilder> {
        public ConstructBuilder() {
            this.ingredientList = new ArrayList();
            this.upgradeContainer = SlotContainer.of(Collections.emptyList());
        }

        public static ConstructBuilder builder() {
            return new ConstructBuilder();
        }

        @Override
        public ConstructedComposite build() {
            this.compositeName();
            IdentifiableContainer id = new IdentifiableContainer(this.name, this.nameSpace, this.type);
            return new ConstructedComposite(this.upgradeContainer, id, this.ingredientList);
        }
    }
}

