/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.state.composite;

import com.sigmundgranaas.forgero.core.condition.ConditionContainer;
import com.sigmundgranaas.forgero.core.condition.Conditional;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.state.IdentifiableContainer;
import com.sigmundgranaas.forgero.core.state.MaterialBased;
import com.sigmundgranaas.forgero.core.state.SchematicBased;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.composite.BaseComposite;
import com.sigmundgranaas.forgero.core.state.composite.ConstructedComposite;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.SlotContainer;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ConstructedSchematicPart
extends ConstructedComposite
implements MaterialBased,
SchematicBased,
Conditional<ConstructedSchematicPart> {
    private final State schematic;
    private final State baseMaterial;
    private final ConditionContainer conditions;
    private int code = 0;

    public ConstructedSchematicPart(State schematic, State baseMaterial, SlotContainer slots, IdentifiableContainer id, ConditionContainer conditions) {
        super(slots, id, List.of(schematic, baseMaterial));
        this.schematic = schematic;
        this.baseMaterial = baseMaterial;
        this.conditions = conditions;
    }

    @Override
    @NotNull
    public List<Property> applyProperty(Matchable target, MatchContext context) {
        return Stream.of(super.applyProperty(target, context), this.conditionProperties(target, context)).flatMap(Collection::stream).toList();
    }

    @Override
    @NotNull
    public List<Property> getRootProperties() {
        return Stream.of(super.getRootProperties(), this.conditionProperties(Matchable.DEFAULT_TRUE, MatchContext.of())).flatMap(Collection::stream).toList();
    }

    @Override
    @NotNull
    public List<Property> getRootProperties(Matchable target, MatchContext context) {
        return Stream.of(super.getRootProperties(target, context), this.conditionProperties(target, context)).flatMap(Collection::stream).toList();
    }

    @Override
    public State baseMaterial() {
        return this.baseMaterial;
    }

    @Override
    public ConstructedSchematicPart upgrade(State upgrade) {
        return ((SchematicPartBuilder)this.partBuilder().addUpgrade(upgrade)).build();
    }

    @Override
    public List<PropertyContainer> compoundedConditions() {
        State state = this.schematic;
        if (state instanceof Conditional) {
            Conditional conditional = (Conditional)((Object)state);
            return Stream.concat(this.localConditions().stream(), conditional.compoundedConditions().stream()).toList();
        }
        return this.localConditions();
    }

    @Override
    public ConstructedSchematicPart removeUpgrade(String id) {
        if (this.upgrades().stream().anyMatch(state -> state.identifier().contains(id))) {
            return ((SchematicPartBuilder)this.partBuilder().addSlotContainer(this.slotContainer.remove(id))).build();
        }
        return this;
    }

    @Override
    public List<PropertyContainer> localConditions() {
        return this.conditions.localConditions();
    }

    @Override
    public ConstructedSchematicPart applyCondition(PropertyContainer container) {
        return this.partBuilder().condition(container).build();
    }

    public SchematicPartBuilder partBuilder() {
        return (SchematicPartBuilder)((SchematicPartBuilder)((SchematicPartBuilder)SchematicPartBuilder.builder(this.schematic(), this.baseMaterial()).addSlotContainer(this.slotContainer.copy())).conditions(this.localConditions()).type(this.type())).id(this.identifier());
    }

    @Override
    public ConstructedSchematicPart removeCondition(String identifier) {
        return this.partBuilder().conditions(Conditional.removeConditions(this.localConditions(), identifier)).build();
    }

    @Override
    public String name() {
        return this.id.name();
    }

    @Override
    public State schematic() {
        return this.schematic;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConstructedSchematicPart that = (ConstructedSchematicPart)o;
        return Objects.equals(this.schematic, that.schematic) && Objects.equals(this.baseMaterial, that.baseMaterial) && Objects.equals(this.conditions, that.conditions);
    }

    @Override
    public int hashCode() {
        if (this.code == 0) {
            this.code = Objects.hash(super.hashCode(), this.schematic, this.baseMaterial, this.conditions);
        }
        return this.code;
    }

    public static class SchematicPartBuilder
    extends BaseComposite.BaseCompositeBuilder<SchematicPartBuilder> {
        protected State schematic;
        protected State baseMaterial;
        protected ConditionContainer conditions;

        public SchematicPartBuilder(State schematic, State material) {
            this.baseMaterial = material;
            this.schematic = schematic;
            this.upgradeContainer = SlotContainer.of(Collections.emptyList());
            this.ingredientList = List.of(schematic, material);
            this.conditions = Conditional.EMPTY;
        }

        public static SchematicPartBuilder builder(State schematic, State material) {
            return new SchematicPartBuilder(schematic, material);
        }

        public static Optional<SchematicPartBuilder> builder(List<State> parts) {
            if (parts.stream().anyMatch(part -> part.test(Type.PART))) {
                return Optional.empty();
            }
            Optional<State> schematic = parts.stream().filter(part -> part.test(Type.SCHEMATIC)).findFirst();
            Optional<State> material = parts.stream().filter(part -> part.test(Type.MATERIAL)).findFirst();
            if (schematic.isPresent() && material.isPresent()) {
                return Optional.of(SchematicPartBuilder.builder(schematic.get(), material.get()));
            }
            return Optional.empty();
        }

        public SchematicPartBuilder condition(PropertyContainer condition) {
            this.conditions = this.conditions.applyCondition(condition);
            return this;
        }

        public SchematicPartBuilder conditions(List<PropertyContainer> conditions) {
            this.conditions = new ConditionContainer(conditions);
            return this;
        }

        @Override
        public ConstructedSchematicPart build() {
            this.compositeName();
            IdentifiableContainer id = new IdentifiableContainer(this.name, this.nameSpace, this.type);
            return new ConstructedSchematicPart(this.schematic, this.baseMaterial, this.upgradeContainer, id, this.conditions);
        }

        public State getSchematic() {
            return this.schematic;
        }

        public State getBaseMaterial() {
            return this.baseMaterial;
        }

        public ConditionContainer getConditions() {
            return this.conditions;
        }
    }
}

