/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.state.composite;

import com.sigmundgranaas.forgero.core.condition.Conditional;
import com.sigmundgranaas.forgero.core.condition.Conditions;
import com.sigmundgranaas.forgero.core.condition.SimpleCondition;
import com.sigmundgranaas.forgero.core.configuration.ForgeroConfigurationLoader;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.soul.Soul;
import com.sigmundgranaas.forgero.core.soul.SoulBindable;
import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.IdentifiableContainer;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.composite.BaseComposite;
import com.sigmundgranaas.forgero.core.state.composite.ConstructedComposite;
import com.sigmundgranaas.forgero.core.state.composite.SoulBoundTool;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.SlotContainer;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ConstructedTool
extends ConstructedComposite
implements SoulBindable,
Conditional<ConstructedTool> {
    private final State head;
    private final State handle;
    private final List<PropertyContainer> conditions;
    private Integer hashCode;

    public ConstructedTool(State head, State handle, SlotContainer slots, IdentifiableContainer id) {
        super(slots, id, List.of(head, handle));
        this.conditions = Collections.emptyList();
        this.head = head;
        this.handle = handle;
    }

    public ConstructedTool(State head, State handle, SlotContainer slots, IdentifiableContainer id, List<PropertyContainer> conditions) {
        super(slots, id, List.of(head, handle));
        this.conditions = conditions;
        this.head = head;
        this.handle = handle;
    }

    @Override
    public ConstructedTool upgrade(State upgrade) {
        return ((ToolBuilder)this.toolBuilder().addUpgrade(upgrade)).build();
    }

    @Override
    public ConstructedTool removeUpgrade(String id) {
        Object compositeRemoved;
        Composite construct;
        int i;
        if (this.upgrades().stream().anyMatch(state -> state.identifier().contains(id))) {
            return ((ToolBuilder)this.toolBuilder().addSlotContainer(this.slotContainer.remove(id))).build();
        }
        for (i = 0; i < this.parts().size(); ++i) {
            State state2 = this.parts().get(i);
            if (!(state2 instanceof Composite) || (construct = (Composite)state2) == (compositeRemoved = (Composite)construct.removeUpgrade(id))) continue;
            ArrayList<State> ingredients = new ArrayList<State>(this.parts());
            ingredients.set(i, (State)compositeRemoved);
            Optional<ToolBuilder> optBuilder = ToolBuilder.builder(ingredients).map(builder -> (ToolBuilder)((ToolBuilder)((ToolBuilder)builder.addSlotContainer(this.slotContainer.copy())).conditions(this.conditions).type(this.type())).id(this.identifier()));
            if (!optBuilder.isPresent()) continue;
            return optBuilder.get().build();
        }
        for (i = 0; i < this.upgrades().size(); ++i) {
            compositeRemoved = this.upgrades().get(i);
            if (!(compositeRemoved instanceof Composite) || (construct = (Composite)compositeRemoved) == (compositeRemoved = (Composite)construct.removeUpgrade(id))) continue;
            Slot slot = this.slots().get(i);
            ArrayList<Slot> slots = new ArrayList<Slot>(this.slots());
            slots.set(i, slot.empty().fill((State)compositeRemoved, slot.category()).orElse(slot.empty()));
            return ((ToolBuilder)this.toolBuilder().addSlotContainer(SlotContainer.of(slots))).build();
        }
        return this;
    }

    public State getHead() {
        return this.head;
    }

    public State getHandle() {
        return this.handle;
    }

    public ToolBuilder toolBuilder() {
        State handle;
        State head = this.getHead();
        if (head instanceof Composite) {
            Composite composite = (Composite)head;
            head = (State)composite.copy();
        }
        if ((handle = this.getHandle()) instanceof Composite) {
            Composite composite = (Composite)handle;
            handle = (State)composite.copy();
        }
        return (ToolBuilder)((ToolBuilder)((ToolBuilder)ToolBuilder.builder(head, handle).addSlotContainer(this.slotContainer.copy())).conditions(this.conditions).type(this.type())).id(this.identifier());
    }

    @Override
    @NotNull
    public List<Property> applyProperty(Matchable target, MatchContext context) {
        return Stream.of(super.applyProperty(target, context), this.conditionProperties(target, context)).flatMap(Collection::stream).toList();
    }

    @Override
    @NotNull
    public List<Property> getRootProperties() {
        return Stream.of(super.getRootProperties(), this.conditionProperties(Matchable.DEFAULT_TRUE, MatchContext.of())).flatMap(Collection::stream).toList();
    }

    @Override
    @NotNull
    public List<Property> getRootProperties(Matchable target, MatchContext context) {
        return Stream.of(super.getRootProperties(target, context), this.conditionProperties(target, context)).flatMap(Collection::stream).toList();
    }

    @Override
    @NotNull
    public List<Property> conditionProperties(Matchable target, MatchContext context) {
        return Conditional.super.conditionProperties(target, context);
    }

    @Override
    public ConstructedTool copy() {
        return this.toolBuilder().build();
    }

    @Override
    public State bind(Soul soul) {
        return this.toolBuilder().soul(soul).build();
    }

    @Override
    public List<PropertyContainer> localConditions() {
        ArrayList<SimpleCondition> customConditions = new ArrayList<SimpleCondition>();
        if (ForgeroConfigurationLoader.configuration.enableUnbreakableTools.booleanValue() && this.conditions.stream().noneMatch(condition -> condition == Conditions.UNBREAKABLE)) {
            customConditions.add(Conditions.UNBREAKABLE);
        }
        return Stream.of(this.conditions, customConditions).flatMap(Collection::stream).toList();
    }

    @Override
    public ConstructedTool applyCondition(PropertyContainer container) {
        return this.toolBuilder().condition(container).build();
    }

    @Override
    public ConstructedTool removeCondition(String identifier) {
        return this.toolBuilder().conditions(Conditional.removeConditions(this.conditions, identifier)).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstructedTool)) {
            return false;
        }
        ConstructedTool that = (ConstructedTool)o;
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.conditions, that.conditions);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = Objects.hash(super.hashCode(), this.conditions);
        }
        return this.hashCode;
    }

    public static class ToolBuilder
    extends BaseComposite.BaseCompositeBuilder<ToolBuilder> {
        protected State head;
        protected State handle;
        protected List<PropertyContainer> conditions;

        public ToolBuilder(State head, State handle) {
            this.head = head;
            this.handle = handle;
            this.upgradeContainer = SlotContainer.of(Collections.emptyList());
            this.ingredientList = List.of(head, handle);
            this.conditions = new ArrayList<PropertyContainer>();
        }

        public static ToolBuilder builder(State head, State handle) {
            return new ToolBuilder(head, handle);
        }

        public static Optional<ToolBuilder> builder(List<State> parts) {
            Optional<State> head = parts.stream().filter(part -> part.test(Type.TOOL_PART_HEAD) || part.test(Type.SWORD_BLADE) || part.test(Type.BOW_LIMB)).findFirst();
            Optional<State> handle = parts.stream().filter(part -> head.orElse(null) != part).findFirst();
            if (head.isPresent() && handle.isPresent()) {
                return Optional.of(ToolBuilder.builder(head.get(), handle.get()));
            }
            return Optional.empty();
        }

        public ToolBuilder head(State head) {
            this.head = head;
            return this;
        }

        public ToolBuilder handle(State handle) {
            this.handle = handle;
            return this;
        }

        public ToolBuilder condition(PropertyContainer condition) {
            this.conditions.add(condition);
            return this;
        }

        public ToolBuilder conditions(List<PropertyContainer> conditions) {
            this.conditions = conditions;
            return this;
        }

        public SoulBoundTool.SoulBoundToolBuilder soul(Soul soul) {
            return SoulBoundTool.SoulBoundToolBuilder.of(this, soul);
        }

        @Override
        public ConstructedTool build() {
            this.compositeName();
            IdentifiableContainer id = new IdentifiableContainer(this.name, this.nameSpace, this.type);
            return new ConstructedTool(this.head, this.handle, this.upgradeContainer, id, this.conditions);
        }

        public State getHead() {
            return this.head;
        }

        public State getHandle() {
            return this.handle;
        }

        public List<PropertyContainer> getConditions() {
            return this.conditions;
        }
    }
}

