/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.state.composite;

import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.soul.Soul;
import com.sigmundgranaas.forgero.core.soul.SoulContainer;
import com.sigmundgranaas.forgero.core.state.IdentifiableContainer;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.composite.ConstructedTool;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.SlotContainer;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class SoulBoundTool
extends ConstructedTool
implements SoulContainer {
    private final Soul soul;

    public SoulBoundTool(State head, State handle, SlotContainer slots, IdentifiableContainer id, Soul soul) {
        super(head, handle, slots, id);
        this.soul = soul;
    }

    public SoulBoundTool(State head, State handle, SlotContainer slots, IdentifiableContainer id, Soul soul, List<PropertyContainer> conditions) {
        super(head, handle, slots, id, conditions);
        this.soul = soul;
    }

    @Override
    @NotNull
    public List<Property> getRootProperties() {
        List<Property> props = super.getRootProperties();
        List<Property> soulProps = this.getSoul().getRootProperties();
        return Stream.of(props, soulProps).flatMap(Collection::stream).toList();
    }

    @Override
    public Soul getSoul() {
        return this.soul;
    }

    @Override
    public SoulBoundToolBuilder toolBuilder() {
        return SoulBoundToolBuilder.of(super.toolBuilder(), this.soul);
    }

    public static class SoulBoundToolBuilder
    extends ConstructedTool.ToolBuilder {
        private Soul soul;

        public SoulBoundToolBuilder(State head, State handle, Soul soul) {
            super(head, handle);
            this.soul = soul;
        }

        public static SoulBoundToolBuilder builder(State head, State handle, Soul soul) {
            return new SoulBoundToolBuilder(head, handle, soul);
        }

        public static SoulBoundToolBuilder of(ConstructedTool.ToolBuilder builder, Soul soul) {
            SoulBoundToolBuilder soulBuilder = new SoulBoundToolBuilder(builder.getHead(), builder.getHandle(), soul);
            soulBuilder.type(builder.getType());
            soulBuilder.name(builder.getName());
            soulBuilder.nameSpace(builder.getNameSpace());
            soulBuilder.addSlotContainer(builder.getUpgradeContainer());
            soulBuilder.conditions(builder.conditions);
            return soulBuilder;
        }

        @Override
        public SoulBoundToolBuilder soul(Soul soul) {
            this.soul = soul;
            return this;
        }

        @Override
        public SoulBoundTool build() {
            this.compositeName();
            IdentifiableContainer id = new IdentifiableContainer(this.name, this.nameSpace, this.type);
            return new SoulBoundTool(this.head, this.handle, this.upgradeContainer, id, this.soul, this.conditions);
        }
    }
}

