/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.state.composite;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.context.Contexts;
import com.sigmundgranaas.forgero.core.customdata.DataContainer;
import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.Target;
import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.SlotContainer;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.core.util.match.NameMatch;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class StaticComposite
implements Composite {
    private final SlotContainer upgrades;
    private final String name;
    private final String nameSpace;
    private final Type type;
    private final PropertyContainer properties;

    public StaticComposite(SlotContainer upgrades, String name, String nameSpace, Type type, PropertyContainer properties) {
        this.upgrades = upgrades;
        this.name = name;
        this.nameSpace = nameSpace;
        this.type = type;
        this.properties = properties;
    }

    @Override
    public List<State> components() {
        return this.upgrades().stream().filter(state -> !state.name().contains("schematic")).toList();
    }

    @Override
    @NotNull
    public List<Property> getRootProperties(Matchable target, MatchContext context) {
        return this.compositeProperties(target, context);
    }

    @Override
    @NotNull
    public List<Property> applyProperty(Matchable target, MatchContext context) {
        MatchContext newContext = context.add(this.type);
        return this.compositeProperties(target, newContext);
    }

    @Override
    public List<Property> compositeProperties(Matchable target, MatchContext context) {
        return Stream.of(this.slots(), List.of(this.properties)).flatMap(Collection::stream).map(container -> container.getRootProperties(target, context)).flatMap(Collection::stream).filter(prop -> {
            Attribute attribute;
            return !(prop instanceof Attribute && (attribute = (Attribute)prop).getContext().test(Contexts.LOCAL));
        }).toList();
    }

    @Override
    public State strip() {
        return new StaticComposite(this.getSlotContainer().strip(), this.name(), this.nameSpace(), this.type(), this.properties);
    }

    @Override
    public boolean test(Matchable match, MatchContext context) {
        if (match instanceof Type) {
            Type typeMatch = (Type)match;
            if (this.type().test(typeMatch, context)) {
                return true;
            }
        }
        if (match instanceof NameMatch) {
            NameMatch named = (NameMatch)match;
            return named.test(this, context);
        }
        return false;
    }

    @Override
    public Optional<State> has(String id) {
        if (this.upgrades().stream().anyMatch(state -> state.identifier().contains(id))) {
            return this.upgrades().stream().filter(state -> state.identifier().contains(id)).findAny();
        }
        return Optional.empty();
    }

    @Override
    public SlotContainer getSlotContainer() {
        return this.upgrades;
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    public String nameSpace() {
        return this.nameSpace;
    }

    @Override
    @NotNull
    public Type type() {
        return this.type;
    }

    @Override
    public Composite upgrade(State upgrade) {
        return this;
    }

    @Override
    public ImmutableList<State> upgrades() {
        return ImmutableList.builder().addAll(this.upgrades.entries()).build();
    }

    @Override
    public Composite removeUpgrade(String id) {
        return this;
    }

    @Override
    public boolean canUpgrade(State state) {
        return this.upgrades.canUpgrade(state);
    }

    @Override
    public List<Slot> slots() {
        return this.upgrades.slots();
    }

    @Override
    public Composite copy() {
        return new StaticComposite(this.upgrades.copy(), this.name(), this.nameSpace(), this.type(), this.properties);
    }

    @Override
    public DataContainer customData(Target target) {
        return DataContainer.empty();
    }
}

