/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.state.upgrade.slot;

import com.sigmundgranaas.forgero.core.property.attribute.Category;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractTypedSlot
implements Slot {
    protected final Set<Category> categories;
    protected final Type type;
    protected final int index;
    protected final String description;

    public AbstractTypedSlot(int index, Type type, String description, Set<Category> categories) {
        this.index = index;
        this.type = type;
        this.description = description;
        this.categories = categories;
    }

    @Override
    public int index() {
        return this.index;
    }

    public Type type() {
        return this.type;
    }

    @Override
    public String description() {
        return this.description.equals(Identifiers.EMPTY_IDENTIFIER) ? this.type().typeName().toLowerCase(Locale.ENGLISH) : this.description;
    }

    @Override
    public Set<Category> category() {
        return this.categories;
    }

    @Override
    public String identifier() {
        return this.description();
    }

    @Override
    public boolean test(Matchable match, MatchContext context) {
        if (match instanceof State) {
            State state = (State)match;
            return state.type().test(this.type, context);
        }
        if (match instanceof Type) {
            Type type = (Type)match;
            return this.type.test(type, context);
        }
        return false;
    }

    @Override
    public String typeName() {
        return this.type.typeName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTypedSlot that = (AbstractTypedSlot)o;
        return this.index == that.index && Objects.equals(this.categories, that.categories) && Objects.equals(this.type, that.type) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.categories, this.type, this.index, this.description);
    }
}

