/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.state.upgrade.slot;

import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.attribute.Category;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.AbstractTypedSlot;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.FilledSlot;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class EmptySlot
extends AbstractTypedSlot {
    public EmptySlot(int index, Type type, String description, Set<Category> categories) {
        super(index, type, description, categories);
    }

    public static List<? extends Slot> of(List<Type> types, Set<Category> categories) {
        return IntStream.range(0, types.size()).mapToObj(arrayIndex -> new EmptySlot(arrayIndex, (Type)types.get(arrayIndex), Identifiers.EMPTY_IDENTIFIER, categories)).toList();
    }

    @Override
    public boolean filled() {
        return false;
    }

    @Override
    public Optional<State> get() {
        return Optional.empty();
    }

    @Override
    public Slot empty() {
        return this;
    }

    @Override
    public Optional<Slot> fill(State slottable, Set<Category> categories) {
        assert (categories != null);
        if (this.test(slottable, MatchContext.of())) {
            return Optional.of(new FilledSlot(this.index(), this.type(), slottable, this.description(), categories));
        }
        return Optional.empty();
    }

    @Override
    public boolean test(Matchable match, MatchContext context) {
        return super.test(match, context);
    }

    @Override
    public Slot copy() {
        return new EmptySlot(this.index, this.type, this.description, this.categories);
    }

    @Override
    @NotNull
    public List<Property> getRootProperties(Matchable target, MatchContext context) {
        return this.getRootProperties();
    }
}

