/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.state.upgrade.slot;

import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.attribute.Category;
import com.sigmundgranaas.forgero.core.property.v2.UpgradePropertyProcessor;
import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.AbstractTypedSlot;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.EmptySlot;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FilledSlot
extends AbstractTypedSlot {
    private final State upgrade;

    public FilledSlot(int index, Type type, State upgrade, String description, Set<Category> categories) {
        super(index, type, description, categories);
        this.upgrade = upgrade;
    }

    @Override
    @NotNull
    public List<Property> getRootProperties() {
        return this.filterProperties(Matchable.DEFAULT_TRUE, MatchContext.of());
    }

    @Override
    @NotNull
    public List<Property> getRootProperties(Matchable target, MatchContext context) {
        return this.filterProperties(target, context);
    }

    @Override
    @NotNull
    public List<Property> applyProperty(Matchable target, MatchContext context) {
        return this.filterProperties(target, context);
    }

    private List<Property> filterProperties(Matchable target, MatchContext context) {
        List<Property> properties = this.upgrade.applyProperty(target, context).stream().map(this.upgrade::applySource).toList();
        return new UpgradePropertyProcessor(this.categories).process(properties, target, context.put(SLOT_CONTEXT_KEY, (Object)this));
    }

    @Override
    public boolean filled() {
        return true;
    }

    @Override
    public Optional<State> get() {
        return Optional.of(this.upgrade);
    }

    public State content() {
        return this.upgrade;
    }

    @Override
    public Slot empty() {
        return new EmptySlot(this.index(), this.type(), this.description(), this.categories);
    }

    @Override
    public Optional<Slot> fill(State slottable, Set<Category> categories) {
        return Optional.empty();
    }

    @Override
    public boolean test(Matchable match, MatchContext context) {
        if (match instanceof State) {
            State state = (State)match;
            return state.type().test(this.type(), context);
        }
        if (this.type().test(match, context)) {
            return true;
        }
        return this.upgrade.test(match, context);
    }

    @Override
    public Slot copy() {
        State upgrade = this.upgrade;
        if (upgrade instanceof Composite) {
            Composite composite = (Composite)upgrade;
            upgrade = (State)composite.copy();
        }
        return new FilledSlot(this.index, this.type, upgrade, this.description, this.categories);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FilledSlot that = (FilledSlot)o;
        return Objects.equals(this.upgrade, that.upgrade);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.upgrade);
    }
}

