/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.state.upgrade.slot;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.state.CopyAble;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SlotContainer
implements CopyAble<SlotContainer> {
    private final List<Slot> slots;

    public SlotContainer(List<Slot> slots) {
        this.slots = slots;
    }

    public static SlotContainer of(List<? extends Slot> slots) {
        return new SlotContainer(new ArrayList<Slot>(slots));
    }

    public Slot set(Slot entry) {
        if (this.slots.size() - 1 >= entry.index()) {
            Slot lastSlot = this.slots.get(entry.index());
            this.slots.set(entry.index(), entry);
            return lastSlot;
        }
        this.slots.add(entry);
        return entry;
    }

    public Optional<Slot> set(State entry) {
        for (Slot slot : this.slots) {
            if (!slot.test(entry, MatchContext.of())) continue;
            Optional<Slot> mappedSlot = slot.fill(entry, slot.category());
            if (mappedSlot.isPresent()) {
                return Optional.of(this.set(mappedSlot.get()));
            }
            if (!slot.filled()) continue;
            Optional<Slot> filledSlot = slot.empty().fill(entry, slot.category());
            return Optional.of(this.set(filledSlot.orElse(slot)));
        }
        return Optional.empty();
    }

    public Slot set(State entry, Slot slot) {
        for (Slot slot1 : this.slots) {
            if (slot != slot1 || !slot.test(entry, MatchContext.of())) continue;
            Optional<Slot> mappedSlot = slot.fill(entry, slot.category());
            if (mappedSlot.isPresent()) {
                this.slots.set(this.slots.indexOf(slot1), mappedSlot.get());
                return mappedSlot.get();
            }
            if (!slot.filled()) continue;
            Slot filledSlot = slot.empty().fill(entry, slot.category()).orElse(slot);
            this.slots.set(this.slots.indexOf(slot1), filledSlot);
            return filledSlot;
        }
        return slot;
    }

    public Optional<Slot> set(State entry, int index) {
        return this.slots.get(index).fill(entry, this.slots.get(index).category());
    }

    public ImmutableList<State> entries() {
        return (ImmutableList)this.slots.stream().map(Slot::get).flatMap(Optional::stream).collect(ImmutableList.toImmutableList());
    }

    public List<Slot> slots() {
        return this.slots;
    }

    public boolean canUpgrade(State state) {
        return this.slots.stream().filter(slot -> !slot.filled()).anyMatch(slot -> slot.test(state, MatchContext.of()));
    }

    @Override
    public SlotContainer copy() {
        return new SlotContainer(this.slots().stream().map(CopyAble::copy).collect(Collectors.toList()));
    }

    public SlotContainer remove(String id) {
        List<Slot> originalSlots = this.slots().stream().filter(slot -> !slot.filled() || slot.get().isPresent() && !slot.get().get().identifier().contains(id)).toList();
        List<Slot> emptySlots = this.slots().stream().filter(slot -> slot.get().isPresent() && slot.get().get().identifier().contains(id)).map(Slot::empty).toList();
        if (emptySlots.isEmpty()) {
            return this;
        }
        return new SlotContainer(Stream.of(originalSlots, emptySlots).flatMap(Collection::stream).toList());
    }

    public Slot empty(Slot slot) {
        if (this.slots.remove(slot)) {
            Slot empty = slot.empty();
            this.slots.add(empty);
            return empty;
        }
        return slot;
    }

    public SlotContainer strip() {
        return new SlotContainer(this.slots().stream().map(Slot::empty).toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotContainer that = (SlotContainer)o;
        return Objects.equals(this.slots, that.slots);
    }

    public int hashCode() {
        return Objects.hash(this.slots);
    }
}

