/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.texture;

import com.sigmundgranaas.forgero.core.identifier.texture.TextureIdentifier;
import com.sigmundgranaas.forgero.core.texture.Texture;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public record RawTexture(TextureIdentifier id, BufferedImage image) implements Texture
{
    public static RawTexture createRawTexture(TextureIdentifier id, InputStream stream) throws IOException {
        try (InputStream inputStream = stream;){
            BufferedImage image = ImageIO.read(stream);
            RawTexture rawTexture = new RawTexture(id, image);
            return rawTexture;
        }
    }

    @Override
    public InputStream getStream() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)this.image, "png", os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        os.close();
        return is;
    }

    @Override
    public BufferedImage getImage() {
        return this.image;
    }

    @Override
    public TextureIdentifier getId() {
        return this.id;
    }
}

