/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.texture.V2;

import com.sigmundgranaas.forgero.core.texture.V2.Texture;
import com.sigmundgranaas.forgero.core.texture.utils.RgbColour;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class Palette
implements Texture {
    private final BufferedImage palette;
    private final List<FramePalette> framePalettes;

    public Palette(BufferedImage palette) {
        this.palette = palette;
        this.framePalettes = new ArrayList<FramePalette>();
        this.extractPalettes();
    }

    private void extractPalettes() {
        int frameHeight = this.palette.getHeight();
        for (int y = 0; y < frameHeight; ++y) {
            ArrayList<RgbColour> colors = new ArrayList<RgbColour>();
            for (int x = 0; x < this.palette.getWidth(); ++x) {
                int rgb = this.palette.getRGB(x, y);
                if ((rgb & 0xFF000000) == 0) continue;
                colors.add(new RgbColour(rgb));
            }
            FramePalette framePalette = new FramePalette(y, colors);
            this.framePalettes.add(framePalette);
        }
    }

    @Override
    public InputStream getStream() throws IOException {
        return Texture.imageToStream(this.palette);
    }

    @Override
    public BufferedImage getImage() {
        return this.palette;
    }

    public List<RgbColour> getColourValues(int frameIndex) {
        if (frameIndex >= 0 && frameIndex < this.framePalettes.size()) {
            return this.framePalettes.get(frameIndex).colours();
        }
        return this.framePalettes.get(0).colours();
    }

    public int getNumberOfPalettes() {
        return this.framePalettes.size();
    }

    public record FramePalette(int frameIndex, List<RgbColour> colours) {
    }
}

