/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.texture.V2;

import com.sigmundgranaas.forgero.core.texture.V2.Palette;
import com.sigmundgranaas.forgero.core.texture.V2.RawTexture;
import com.sigmundgranaas.forgero.core.texture.V2.Texture;
import com.sigmundgranaas.forgero.core.texture.V2.recolor.RecolorStrategy;
import com.sigmundgranaas.forgero.core.texture.template.PixelInformation;
import com.sigmundgranaas.forgero.core.texture.utils.RgbColour;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class TemplateTexture
implements Texture {
    private final BufferedImage template;
    private final RecolorStrategy strategy;
    private final int frameSize;
    private final List<List<PixelInformation>> framesPixelInfo;
    private final List<List<RgbColour>> framesGreyScaleValues;

    public TemplateTexture(BufferedImage template, RecolorStrategy strategy) {
        this.template = template;
        this.strategy = strategy;
        this.frameSize = template.getWidth();
        this.framesPixelInfo = new ArrayList<List<PixelInformation>>();
        this.framesGreyScaleValues = new ArrayList<List<RgbColour>>();
        this.processFrames();
    }

    private void processFrames() {
        int numFrames = this.template.getHeight() / this.frameSize;
        for (int i = 0; i < numFrames; ++i) {
            BufferedImage frame = this.template.getSubimage(0, i * this.frameSize, this.frameSize, this.frameSize);
            this.framesPixelInfo.add(this.extractPixelInfo(frame));
        }
    }

    private List<PixelInformation> extractPixelInfo(BufferedImage frame) {
        ArrayList<PixelInformation> pixelInfoList = new ArrayList<PixelInformation>();
        HashSet<RgbColour> greyScaleSet = new HashSet<RgbColour>();
        for (int y = 0; y < frame.getHeight(); ++y) {
            for (int x = 0; x < frame.getWidth(); ++x) {
                int rgb = frame.getRGB(x, y);
                if ((rgb & 0xFF000000) == 0) continue;
                RgbColour colour = new RgbColour(rgb);
                pixelInfoList.add(new PixelInformation(x, y, colour));
                greyScaleSet.add(colour);
            }
        }
        this.framesGreyScaleValues.add(greyScaleSet.stream().sorted().collect(Collectors.toList()));
        return pixelInfoList;
    }

    @Override
    public InputStream getStream() throws IOException {
        return Texture.imageToStream(this.getImage());
    }

    @Override
    public BufferedImage getImage() {
        return this.template;
    }

    public List<RgbColour> getGreyScaleValues(int frameIndex) {
        if (frameIndex >= 0 && frameIndex < this.framesGreyScaleValues.size()) {
            return this.framesGreyScaleValues.get(frameIndex);
        }
        return this.framesGreyScaleValues.get(0);
    }

    public List<PixelInformation> getPixelInfo(int frameIndex) {
        if (frameIndex >= 0 && frameIndex < this.framesPixelInfo.size()) {
            return this.framesPixelInfo.get(frameIndex);
        }
        return this.framesPixelInfo.get(0);
    }

    public int getNumberOfGreyScales() {
        return this.framesGreyScaleValues.size();
    }

    public RawTexture apply(Palette palette) {
        return new RawTexture(this.strategy.recolor(this, palette));
    }

    public int getFrameSize() {
        return this.frameSize;
    }
}

