/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.texture.V2;

import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.configuration.ForgeroConfigurationLoader;
import com.sigmundgranaas.forgero.core.model.PaletteTemplateModel;
import com.sigmundgranaas.forgero.core.texture.V2.FileLoader;
import com.sigmundgranaas.forgero.core.texture.V2.Palette;
import com.sigmundgranaas.forgero.core.texture.V2.RawTexture;
import com.sigmundgranaas.forgero.core.texture.V2.TemplateTexture;
import com.sigmundgranaas.forgero.core.texture.V2.Texture;
import com.sigmundgranaas.forgero.core.texture.V2.TextureService;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;

public class TextureGenerator {
    public static TextureGenerator INSTANCE;
    private final TextureService service;

    public TextureGenerator(FileLoader loader, Map<String, String> paletteRemap) {
        this.service = new TextureService(loader, paletteRemap);
    }

    public static TextureGenerator getInstance(FileLoader loader, Map<String, String> paletteRemap) {
        if (INSTANCE == null) {
            INSTANCE = new TextureGenerator(loader, paletteRemap);
        }
        return INSTANCE;
    }

    public Optional<JsonObject> getMetadata(PaletteTemplateModel templateModel, String extension) {
        Optional<JsonObject> palette = this.service.getPaletteMetadata(templateModel.palette(), extension);
        Optional<JsonObject> template = this.service.getTemplateMetadata(templateModel.template(), extension);
        if (palette.isPresent() || template.isPresent()) {
            return palette.isPresent() ? palette : template;
        }
        return Optional.empty();
    }

    public Optional<Texture> getTexture(PaletteTemplateModel templateModel) {
        Optional<Palette> palette = this.service.getPalette(templateModel.palette() + ".png");
        Optional<TemplateTexture> template = this.service.getTemplate(templateModel.template());
        if (palette.isPresent() && template.isPresent()) {
            RawTexture texture = new RawTexture(template.get().apply(palette.get()).getImage());
            if (ForgeroConfigurationLoader.configuration.exportGeneratedTextures.booleanValue()) {
                this.saveImage(texture, templateModel.name());
            }
            return Optional.of(texture);
        }
        return Optional.empty();
    }

    public void clear() {
        this.service.clear();
    }

    private void saveImage(RawTexture texture, String name) {
        String outputPath = "./export/generated_textures/";
        File outputFile = new File(outputPath + name);
        if (!outputFile.exists()) {
            outputFile.mkdirs();
        }
        try {
            ImageIO.write((RenderedImage)texture.image(), "png", outputFile);
            Forgero.LOGGER.info("exported: {}", (Object)outputFile.toString());
        }
        catch (IOException e) {
            Forgero.LOGGER.error((Object)e);
        }
    }
}

