/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.texture.V2;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.sigmundgranaas.forgero.core.texture.V2.FileLoader;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import javax.imageio.ImageIO;

public class TextureLoader {
    private final FileLoader loader;

    public TextureLoader(FileLoader loader) {
        this.loader = loader;
    }

    Optional<BufferedImage> load(String location) {
        Optional<InputStream> streamOpt = this.loader.getStream(location);
        if (streamOpt.isPresent()) {
            Optional<BufferedImage> optional;
            block9: {
                InputStream stream = streamOpt.get();
                InputStream inputStream = stream;
                try {
                    optional = Optional.of(ImageIO.read(stream));
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return Optional.empty();
                    }
                }
                inputStream.close();
            }
            return optional;
        }
        return Optional.empty();
    }

    public Optional<JsonObject> loadMetadata(String name) {
        Optional<InputStream> streamOpt = this.loader.getStreamSilent(name);
        if (streamOpt.isPresent()) {
            Optional<JsonObject> optional;
            block9: {
                InputStream stream = streamOpt.get();
                InputStream inputStream = stream;
                try {
                    JsonReader reader = new JsonReader((Reader)new InputStreamReader(stream));
                    optional = Optional.of((JsonObject)new Gson().fromJson(reader, JsonObject.class));
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return Optional.empty();
                    }
                }
                inputStream.close();
            }
            return optional;
        }
        return Optional.empty();
    }
}

