/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.texture.V2;

import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.texture.V2.FileLoader;
import com.sigmundgranaas.forgero.core.texture.V2.Palette;
import com.sigmundgranaas.forgero.core.texture.V2.TemplateTexture;
import com.sigmundgranaas.forgero.core.texture.V2.TextureLoader;
import com.sigmundgranaas.forgero.core.texture.V2.recolor.DefaultRecolorStrategy;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TextureService {
    public static String PALETTE_PATH = "assets/forgero/templates/materials/";
    public static String TEMPLATE_PATH = "assets/forgero/templates/textures/";
    private final TextureLoader loader;
    private final Map<String, String> paletteRemap;
    private final Map<String, JsonObject> metaCache;
    private final Set<String> attemptedTextures;
    private Map<String, Palette> paletteCache = new HashMap<String, Palette>();
    private Map<String, TemplateTexture> templateCache;

    public TextureService(FileLoader loader, Map<String, String> paletteRemap) {
        this.paletteRemap = paletteRemap;
        this.templateCache = new HashMap<String, TemplateTexture>();
        this.metaCache = new HashMap<String, JsonObject>();
        this.attemptedTextures = new HashSet<String>();
        this.loader = new TextureLoader(loader);
    }

    public Optional<Palette> getPalette(String name) {
        Optional<Palette> remapped = Optional.ofNullable(this.paletteRemap.get(name)).flatMap(this::getPalette);
        if (remapped.isPresent()) {
            return remapped;
        }
        if (this.paletteCache.containsKey(name)) {
            return Optional.ofNullable(this.paletteCache.get(name));
        }
        Optional<BufferedImage> paletteTexture = this.loader.load(PALETTE_PATH + name);
        Optional<Palette> paletteOpt = paletteTexture.map(Palette::new);
        if (paletteOpt.isPresent()) {
            Palette palette = paletteOpt.get();
            if (palette.getColourValues(0).size() >= 2) {
                this.paletteCache.put(name, palette);
                return Optional.of(palette);
            }
            Forgero.LOGGER.error("Encountered Palette texture: {} with a limited number of color values: {}. This palette will not be processed.", (Object)(PALETTE_PATH + name), (Object)palette.getColourValues(0).size());
        }
        return Optional.empty();
    }

    public void clear() {
        this.templateCache = new ConcurrentHashMap<String, TemplateTexture>();
        this.paletteCache = new ConcurrentHashMap<String, Palette>();
    }

    public Optional<TemplateTexture> getTemplate(String name) {
        if (this.templateCache.containsKey(name)) {
            return Optional.of(this.templateCache.get(name));
        }
        Optional<BufferedImage> templateOpt = this.loader.load(TEMPLATE_PATH + name);
        if (templateOpt.isPresent()) {
            TemplateTexture texture = new TemplateTexture(templateOpt.get(), new DefaultRecolorStrategy());
            if (texture.getGreyScaleValues(0).size() >= 2) {
                this.templateCache.put(name, texture);
                return Optional.of(texture);
            }
            Forgero.LOGGER.error("Encountered template texture: {} with a limited number of grayscale values: {}. This texture will not be processed.", (Object)(TEMPLATE_PATH + name), (Object)texture.getGreyScaleValues(0).size());
        }
        return Optional.empty();
    }

    public Optional<JsonObject> getPaletteMetadata(String texture, String extension) {
        return this.getMetadata(PALETTE_PATH + texture + ".png" + extension);
    }

    public Optional<JsonObject> getTemplateMetadata(String texture, String extension) {
        return this.getMetadata(TEMPLATE_PATH + texture + extension);
    }

    public Optional<JsonObject> getMetadata(String name) {
        if (this.attemptedTextures.contains(name)) {
            return Optional.empty();
        }
        if (this.metaCache.containsKey(name)) {
            return Optional.ofNullable(this.metaCache.get(name));
        }
        Optional<JsonObject> meta = this.loader.loadMetadata(name);
        if (meta.isPresent()) {
            this.metaCache.put(name, meta.get());
            return meta;
        }
        this.attemptedTextures.add(name);
        return Optional.empty();
    }
}

