/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.texture.V2.recolor;

import com.sigmundgranaas.forgero.core.texture.V2.Palette;
import com.sigmundgranaas.forgero.core.texture.V2.TemplateTexture;
import com.sigmundgranaas.forgero.core.texture.V2.recolor.RecolorStrategy;
import com.sigmundgranaas.forgero.core.texture.template.PixelInformation;
import com.sigmundgranaas.forgero.core.texture.utils.RgbColour;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class DefaultRecolorStrategy
implements RecolorStrategy {
    @Override
    public BufferedImage recolor(TemplateTexture template, Palette palette) {
        int templateFramesCount = template.getNumberOfGreyScales();
        int paletteFramesCount = palette.getNumberOfPalettes();
        if (templateFramesCount == 1 && paletteFramesCount == 1) {
            return this.recolorSingleFrame(template, palette, 0);
        }
        int recoloredImageHeight = template.getFrameSize() * Math.max(templateFramesCount, paletteFramesCount);
        BufferedImage recoloredImage = new BufferedImage(template.getFrameSize(), recoloredImageHeight, 2);
        if (templateFramesCount > 1 && paletteFramesCount == 1) {
            for (int frameIndex = 0; frameIndex < templateFramesCount; ++frameIndex) {
                BufferedImage frameImage = this.recolorSingleFrame(template, palette, frameIndex);
                this.copyFrameToImage(recoloredImage, frameImage, frameIndex, template.getFrameSize());
            }
        } else if (templateFramesCount == 1) {
            for (int frameIndex = 0; frameIndex < paletteFramesCount; ++frameIndex) {
                BufferedImage frameImage = this.recolorSingleFrame(template, palette, frameIndex);
                this.copyFrameToImage(recoloredImage, frameImage, frameIndex, template.getFrameSize());
            }
        } else {
            for (int frameIndex = 0; frameIndex < templateFramesCount; ++frameIndex) {
                int normalizedPaletteIndex = frameIndex % paletteFramesCount;
                BufferedImage frameImage = this.recolorSingleFrame(template, palette, normalizedPaletteIndex);
                this.copyFrameToImage(recoloredImage, frameImage, frameIndex, template.getFrameSize());
            }
        }
        return recoloredImage;
    }

    private BufferedImage recolorSingleFrame(TemplateTexture template, Palette palette, int frameIndex) {
        List<RgbColour> paletteValues = this.createUsableColourPalette(template, palette, frameIndex);
        List<RgbColour> greyScaleValues = template.getGreyScaleValues(frameIndex);
        List<PixelInformation> pixelValues = template.getPixelInfo(frameIndex);
        BufferedImage frameImage = new BufferedImage(template.getFrameSize(), template.getFrameSize(), 2);
        for (PixelInformation pixel : pixelValues) {
            int colorIndex = this.findIntPosition(pixel.getRgbColor(), greyScaleValues);
            int rgb = paletteValues.get(colorIndex).getRgb();
            frameImage.setRGB(pixel.getLengthIndex(), pixel.getHeightIndex(), rgb);
        }
        return frameImage;
    }

    private void copyFrameToImage(BufferedImage targetImage, BufferedImage frame, int frameIndex, int frameSize) {
        int yPosition = frameIndex * frameSize;
        Graphics2D g = targetImage.createGraphics();
        g.drawImage((Image)frame, 0, yPosition, null);
        g.dispose();
    }

    public int findIntPosition(RgbColour target, List<RgbColour> reference) {
        for (int i = 0; i < reference.size(); ++i) {
            if (!target.equals(reference.get(i))) continue;
            return i;
        }
        return 0;
    }

    public List<RgbColour> createUsableColourPalette(TemplateTexture template, Palette palette, int frameIndex) {
        List<RgbColour> greyScaleValues = template.getGreyScaleValues(frameIndex);
        List<RgbColour> paletteValues = palette.getColourValues(frameIndex);
        int greyScaleSize = greyScaleValues.size();
        ArrayList<RgbColour> normalizedColourList = new ArrayList<RgbColour>(greyScaleSize);
        if (greyScaleSize == paletteValues.size()) {
            normalizedColourList.addAll(paletteValues);
            return normalizedColourList;
        }
        for (int i = 0; i < greyScaleSize; ++i) {
            float scaleValue = (float)paletteValues.size() / (float)greyScaleSize;
            float normalizedIndex = scaleValue * (float)i;
            int newIndex = Math.min(Math.round(normalizedIndex), paletteValues.size() - 1);
            normalizedColourList.add(paletteValues.get(newIndex));
        }
        return normalizedColourList;
    }
}

