/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.texture.template;

import com.sigmundgranaas.forgero.core.identifier.texture.TemplateIdentifier;
import com.sigmundgranaas.forgero.core.texture.Texture;
import com.sigmundgranaas.forgero.core.texture.template.PixelInformation;
import com.sigmundgranaas.forgero.core.texture.utils.RgbColour;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class TemplateTexture2
implements Texture {
    private final List<PixelInformation> pixelValues;
    private final List<RgbColour> greyScaleValues;
    private final TemplateIdentifier id;

    public TemplateTexture2(ArrayList<PixelInformation> pixelValues, List<RgbColour> greyScaleValues, TemplateIdentifier id) {
        this.pixelValues = pixelValues;
        this.greyScaleValues = greyScaleValues;
        this.id = id;
    }

    public List<RgbColour> getGreyScaleValues() {
        return this.greyScaleValues;
    }

    public List<PixelInformation> getPixelValues() {
        return this.pixelValues;
    }

    @Override
    public InputStream getStream() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)this.getImage(), "png", os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        os.close();
        return is;
    }

    @Override
    public TemplateIdentifier getId() {
        return this.id;
    }

    @Override
    public BufferedImage getImage() {
        BufferedImage paletteImage = new BufferedImage(32, 32, 2);
        for (PixelInformation pixel : this.pixelValues) {
            paletteImage.setRGB(pixel.getLengthIndex(), pixel.getHeightIndex(), pixel.getRgbColor().getRgb());
        }
        return paletteImage;
    }
}

