/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.texture.utils;

import com.sigmundgranaas.forgero.core.texture.utils.Offset;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.List;

public class ImageOffset {
    public static BufferedImage applyOffset(BufferedImage input, List<Offset> offsetList) {
        BufferedImage newImage = new BufferedImage(input.getWidth(), input.getHeight(), 2);
        Offset offset = offsetList.stream().reduce(new Offset(0.0f, 0.0f), (offset1, offset2) -> new Offset(offset1.x() + offset2.x(), offset1.y() + offset2.y()));
        int transparent = new Color(0, 0, 0, 0).getRGB();
        for (int i = 0; i < input.getWidth(); ++i) {
            for (int j = 0; j < input.getHeight(); ++j) {
                Offset currentPixel = new Offset(i, j);
                Offset newPixel = currentPixel.apply(offset);
                if (newPixel.x() >= 0.0f && newPixel.x() < (float)input.getWidth() && newPixel.y() >= 0.0f && newPixel.y() < (float)input.getHeight()) {
                    newImage.setRGB(i, j, input.getRGB((int)newPixel.x(), (int)newPixel.y()));
                    continue;
                }
                newImage.setRGB(i, j, transparent);
            }
        }
        return newImage;
    }
}

