/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.texture.utils;

import org.jetbrains.annotations.NotNull;

public class RgbColour
implements Comparable<RgbColour> {
    private final int red;
    private final int green;
    private final int blue;
    private int original;

    public RgbColour(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public RgbColour(int rgba) {
        this.original = rgba;
        int red = rgba >> 16 & 0xFF;
        int blue = rgba >> 8 & 0xFF;
        int green = rgba & 0xFF;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public int getLightValue() {
        return (this.red + this.green + this.blue) / 3;
    }

    public int getRgb() {
        return this.original;
    }

    public String toString() {
        return "RgbColour{red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RgbColour rgbColour = (RgbColour)o;
        if (this.red != rgbColour.red) {
            return false;
        }
        if (this.green != rgbColour.green) {
            return false;
        }
        return this.blue == rgbColour.blue;
    }

    public int hashCode() {
        int result = this.red;
        result = 31 * result + this.green;
        result = 31 * result + this.blue;
        return result;
    }

    @Override
    public int compareTo(@NotNull RgbColour o) {
        return this.getLightValue() - o.getLightValue();
    }
}

