/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.type;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.type.SimpleType;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.type.TypeNode;
import com.sigmundgranaas.forgero.core.util.TypeMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class MutableTypeNode {
    private final String name;
    private final List<MutableTypeNode> children;
    private final HashMap<Class<?>, List<Object>> resourceMap;
    private List<MutableTypeNode> parent;

    public MutableTypeNode(@NotNull List<MutableTypeNode> children, @NotNull String name, @NotNull List<MutableTypeNode> parent) {
        this.parent = parent;
        this.children = children;
        this.name = name;
        this.resourceMap = new HashMap();
    }

    public List<MutableTypeNode> parent() {
        return this.parent;
    }

    public List<MutableTypeNode> children() {
        return this.children;
    }

    public List<MutableTypeNode> allChildren(List<MutableTypeNode> children) {
        children.addAll(this.children());
        this.children().forEach(child -> child.allChildren(children));
        return children;
    }

    public MutableTypeNode addChild(MutableTypeNode child) {
        MutableTypeNode parentedChild = child.addParent(this);
        this.children.add(child);
        return parentedChild;
    }

    public <T> void addResource(@NotNull Object resource, Class<T> type) {
        if (this.resourceMap.containsKey(type)) {
            this.resourceMap.get(type).add(resource);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(resource);
            this.resourceMap.put(type, arrayList);
        }
    }

    public <T> ImmutableList<T> getResources(Class<T> type) {
        ImmutableList childrenResources = (ImmutableList)this.children.stream().map(node -> node.getResources(type)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        if (this.resourceMap.containsKey(type)) {
            List<Object> resources = Optional.ofNullable(this.resourceMap.get(type)).stream().flatMap(Collection::stream).filter(type::isInstance).map(type::cast).toList();
            return ImmutableList.builder().addAll((Iterable)childrenResources).addAll(resources).build();
        }
        return childrenResources;
    }

    public MutableTypeNode addParent(MutableTypeNode parent) {
        this.parent = new ArrayList<MutableTypeNode>(this.parent);
        this.parent.add(parent);
        return this;
    }

    public TypeNode resolve() {
        ImmutableList children = (ImmutableList)this.children().stream().map(MutableTypeNode::resolve).collect(ImmutableList.toImmutableList());
        TypeNode parentNode = new TypeNode((ImmutableList<TypeNode>)children, this.name, this.resourceMap);
        children.forEach(node -> node.link(parentNode));
        return parentNode;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        if (!this.parent.isEmpty()) {
            return new SimpleType(this.name, this.parent.stream().map(MutableTypeNode::type).toList(), new TypeMatcher());
        }
        return new SimpleType(this.name, Optional.empty(), new TypeMatcher());
    }
}

