/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.type;

import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.TypeMatcher;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SimpleType
implements Type {
    private final String name;
    private final List<Type> parent;
    private final TypeMatcher matcher;

    public SimpleType(String name, List<Type> parent, TypeMatcher matcher) {
        this.name = name;
        this.parent = parent;
        this.matcher = matcher;
    }

    public SimpleType(String name, Optional<Type> parent, TypeMatcher matcher) {
        this.name = name;
        this.parent = parent.map(List::of).orElse(List.of());
        this.matcher = matcher;
    }

    @Override
    public boolean test(Matchable match, MatchContext context) {
        if (match instanceof Type) {
            Type type = (Type)match;
            if (this.name.equals(type.typeName())) {
                return this.matcher.test(match, context);
            }
            if (!this.parent.isEmpty()) {
                return this.parent.stream().anyMatch(parent -> parent.test(match, context));
            }
        }
        return false;
    }

    @Override
    public String typeName() {
        return this.name;
    }

    @Override
    public List<Type> parent() {
        return this.parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleType that = (SimpleType)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.parent, that.parent);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parent);
    }
}

