/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.type;

import com.sigmundgranaas.forgero.core.ForgeroStateRegistry;
import com.sigmundgranaas.forgero.core.type.SimpleType;
import com.sigmundgranaas.forgero.core.util.SchematicMatcher;
import com.sigmundgranaas.forgero.core.util.TypeMatcher;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface Type
extends Matchable {
    public static final Type HOLDABLE = new SimpleType("HOLDABLE", Optional.empty(), new TypeMatcher());
    public static final Type TOOL = new SimpleType("TOOL", Optional.of(HOLDABLE), new TypeMatcher());
    public static final Type PICKAXE = new SimpleType("PICKAXE", Optional.of(TOOL), new TypeMatcher());
    public static final Type AXE = new SimpleType("AXE", Optional.of(TOOL), new TypeMatcher());
    public static final Type WEAPON = new SimpleType("WEAPON", Optional.of(HOLDABLE), new TypeMatcher());
    public static final Type SWORD = new SimpleType("SWORD", Optional.of(WEAPON), new TypeMatcher());
    public static final Type BOW = new SimpleType("BOW", Optional.of(WEAPON), new TypeMatcher());
    public static final Type PART = new SimpleType("PART", Optional.empty(), new TypeMatcher());
    public static final Type BINDING = new SimpleType("BINDING", Optional.of(PART), new TypeMatcher());
    public static final Type SWORD_GUARD = new SimpleType("SWORD_GUARD", Optional.of(PART), new TypeMatcher());
    public static final Type TOOL_PART_HEAD = new SimpleType("TOOL_PART_HEAD", Optional.of(PART), new TypeMatcher());
    public static final Type AXE_HEAD = new SimpleType("AXE_HEAD", Optional.of(TOOL_PART_HEAD), new TypeMatcher());
    public static final Type HOE_HEAD = new SimpleType("HOE_HEAD", Optional.of(TOOL_PART_HEAD), new TypeMatcher());
    public static final Type PICKAXE_HEAD = new SimpleType("PICKAXE_HEAD", Optional.of(TOOL_PART_HEAD), new TypeMatcher());
    public static final Type SHOVEL_HEAD = new SimpleType("SHOVEL_HEAD", Optional.of(TOOL_PART_HEAD), new TypeMatcher());
    public static final Type HANDLE = new SimpleType("HANDLE", Optional.empty(), new TypeMatcher());
    public static final Type BLADE = new SimpleType("BLADE", Optional.empty(), new TypeMatcher());
    public static final Type SWORD_BLADE = new SimpleType("SWORD_BLADE", Optional.of(BLADE), new TypeMatcher());
    public static final Type SCHEMATIC = new SimpleType("SCHEMATIC", Optional.empty(), (TypeMatcher)new SchematicMatcher());
    public static final Type SWORD_BLADE_SCHEMATIC = new SimpleType("SWORD_BLADE_SCHEMATIC", Optional.of(SCHEMATIC), (TypeMatcher)new SchematicMatcher());
    public static final Type TOOL_PART_HEAD_SCHEMATIC = new SimpleType("SWORD_PART_HEAD_SCHEMATIC", Optional.of(SCHEMATIC), (TypeMatcher)new SchematicMatcher());
    public static final Type HANDLE_SCHEMATIC = new SimpleType("HANDLE_SCHEMATIC", Optional.of(SCHEMATIC), (TypeMatcher)new SchematicMatcher());
    public static final Type PICKAXE_SCHEMATIC = new SimpleType("PICKAXE_SCHEMATIC", Optional.of(SCHEMATIC), (TypeMatcher)new SchematicMatcher());
    public static final Type BINDING_SCHEMATIC = new SimpleType("BINDING_SCHEMATIC", Optional.of(SCHEMATIC), (TypeMatcher)new SchematicMatcher());
    public static final Type TRINKET = new SimpleType("TRINKET", Optional.empty(), (TypeMatcher)new SchematicMatcher());
    public static final Type GEM = new SimpleType("GEM", Optional.of(TRINKET), (TypeMatcher)new SchematicMatcher());
    public static final Type UNDEFINED = new SimpleType("UNDEFINED", Optional.empty(), new TypeMatcher());
    public static final Type MATERIAL = new SimpleType("MATERIAL", Optional.empty(), new TypeMatcher());
    public static final Type TOOL_MATERIAL = new SimpleType("TOOL_MATERIAL", Optional.of(MATERIAL), new TypeMatcher());
    public static final Type WOOD = new SimpleType("WOOD", Optional.of(TOOL_MATERIAL), new TypeMatcher());
    public static final Type OAK = new SimpleType("OAK", Optional.of(WOOD), new TypeMatcher());
    public static final Type METAL = new SimpleType("METAL", Optional.of(TOOL_MATERIAL), new TypeMatcher());
    public static final Type STONE = new SimpleType("STONE", Optional.of(TOOL_MATERIAL), new TypeMatcher());
    public static final Type SECONDARY_MATERIAL = new SimpleType("SECONDARY_MATERIAL", Optional.of(MATERIAL), new TypeMatcher());
    public static final Type STRING = new SimpleType("STRING", Optional.of(SECONDARY_MATERIAL), new TypeMatcher());
    public static final Type BOW_LIMB = new SimpleType("BOW_LIMB", Optional.of(PART), new TypeMatcher());
    public static final Type ARROW = new SimpleType("ARROW", Optional.empty(), new TypeMatcher());
    public static final Type ARROW_HEAD = new SimpleType("ARROW_HEAD", Optional.of(PART), new TypeMatcher());

    public static Type of(String name) {
        Object type;
        if (ForgeroStateRegistry.TREE != null && ((Optional)(type = ForgeroStateRegistry.TREE.find(name))).isPresent()) {
            return ((Optional)type).get().type();
        }
        type = new SimpleType(name.toUpperCase(), Optional.empty(), new TypeMatcher());
        if (((SimpleType)type).test(SCHEMATIC, MatchContext.of())) {
            return new SimpleType(name.toUpperCase(), Optional.empty(), (TypeMatcher)new SchematicMatcher());
        }
        return type;
    }

    public static Type of(String name, Type parent) {
        SimpleType type = new SimpleType(name.toUpperCase(), Optional.of(parent), new TypeMatcher());
        if (type.test(SCHEMATIC, MatchContext.of())) {
            return new SimpleType(name.toUpperCase(), Optional.of(parent), new TypeMatcher());
        }
        return type;
    }

    public String typeName();

    default public List<Type> parent() {
        return Collections.emptyList();
    }
}

