/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.type;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class TypeNode {
    private final String name;
    private final ImmutableList<TypeNode> children;
    private final HashMap<Class<?>, List<Object>> resourceMap;
    @Nullable
    private TypeNode parent = null;

    public TypeNode(ImmutableList<TypeNode> children, String name, HashMap<Class<?>, List<Object>> resourceMap) {
        this.children = children;
        this.name = name;
        this.resourceMap = resourceMap;
    }

    void link(@Nullable TypeNode parent) {
        this.parent = parent;
    }

    public Optional<TypeNode> parent() {
        return Optional.ofNullable(this.parent);
    }

    public <T> ImmutableList<T> getResources(Class<T> type) {
        ImmutableList childrenResources = (ImmutableList)this.children.stream().map(node -> node.getResources(type)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        if (this.resourceMap.containsKey(type)) {
            List<Object> resources = Optional.ofNullable(this.resourceMap.get(type)).stream().flatMap(Collection::stream).filter(type::isInstance).map(type::cast).toList();
            return ImmutableList.builder().addAll((Iterable)childrenResources).addAll(resources).build();
        }
        return childrenResources;
    }

    public ImmutableList<TypeNode> children() {
        return this.children;
    }

    public String name() {
        return this.name;
    }
}

