/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.type;

import com.sigmundgranaas.forgero.core.resource.data.v2.data.TypeData;
import com.sigmundgranaas.forgero.core.type.MutableTypeNode;
import com.sigmundgranaas.forgero.core.type.MutableTypeTree;
import com.sigmundgranaas.forgero.core.type.ResolvedTree;
import com.sigmundgranaas.forgero.core.type.ResolvedTypeTree;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.type.TypeNode;
import com.sigmundgranaas.forgero.core.type.UnresolvedTypeTree;
import com.sigmundgranaas.forgero.core.util.Identifiers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class TypeTree
implements UnresolvedTypeTree,
MutableTypeTree {
    private final List<MutableTypeNode> rootNodes = new ArrayList<MutableTypeNode>();
    private List<TypeData> missingNodes = new ArrayList<TypeData>();

    @Override
    public Optional<MutableTypeNode> addNode(TypeData nodeData) {
        Optional<MutableTypeNode> nodeOpt = this.find(nodeData.name());
        if (nodeOpt.isEmpty()) {
            if (nodeData.parent().isPresent()) {
                return this.addNodeWithParent(nodeData.name(), nodeData.parent().get());
            }
            MutableTypeNode node2 = new MutableTypeNode(new ArrayList<MutableTypeNode>(), nodeData.name(), Collections.emptyList());
            this.rootNodes.add(node2);
            return Optional.of(node2);
        }
        if (nodeData.parent().isPresent()) {
            Optional<MutableTypeNode> parentOpt = this.find(nodeData.parent().get());
            if (parentOpt.isPresent()) {
                parentOpt.get().addChild(nodeOpt.get());
                return nodeOpt;
            }
            if (this.missingNodes.stream().noneMatch(node -> node.name().equals(nodeData.name()))) {
                this.missingNodes.add(new TypeData(nodeData.name(), nodeData.parent(), Collections.emptyList()));
            }
        }
        return Optional.empty();
    }

    @Override
    public void addNodes(List<TypeData> nodes) {
        nodes.forEach(this::addNode);
        this.resolve();
    }

    private Optional<MutableTypeNode> addNodeWithParent(String name, String parent) {
        Optional<MutableTypeNode> parentOpt = this.find(parent);
        if (parentOpt.isPresent()) {
            MutableTypeNode node2 = new MutableTypeNode(new ArrayList<MutableTypeNode>(), name, Collections.emptyList());
            return Optional.of(parentOpt.get().addChild(node2));
        }
        if (this.missingNodes.stream().noneMatch(node -> node.name().equals(name))) {
            this.missingNodes.add(new TypeData(name, Optional.of(parent), Collections.emptyList()));
        }
        return Optional.empty();
    }

    @Override
    public synchronized ResolvedTypeTree resolve() {
        if (this.missingNodes.isEmpty()) {
            return new ResolvedTree(this.resolveNodes());
        }
        int missing = this.missingNodes.size();
        ArrayList<TypeData> missingCopy = new ArrayList<TypeData>(this.missingNodes);
        List<MutableTypeNode> addedNodes = missingCopy.stream().map(this::addNode).flatMap(Optional::stream).toList();
        this.removeMissingNodes(addedNodes);
        if (missing > addedNodes.size()) {
            this.resolve();
        }
        return new ResolvedTree(this.resolveNodes());
    }

    public List<TypeNode> resolveNodes() {
        return this.rootNodes.stream().map(MutableTypeNode::resolve).toList();
    }

    public List<MutableTypeNode> nodes() {
        ArrayList<MutableTypeNode> list = new ArrayList<MutableTypeNode>(this.rootNodes);
        this.rootNodes.forEach(node -> node.allChildren(list));
        return list;
    }

    private void removeMissingNodes(List<MutableTypeNode> nodes) {
        this.missingNodes = new ArrayList<TypeData>(this.missingNodes.stream().filter(missingNode -> nodes.stream().noneMatch(node -> node.name().equals(missingNode.name()))).toList());
    }

    @Override
    public Optional<MutableTypeNode> find(String name) {
        return this.rootNodes.stream().map(typeNode -> this.find(name, (MutableTypeNode)typeNode).map(MutableTypeNode.class::cast)).flatMap(Optional::stream).findAny();
    }

    public Optional<MutableTypeNode> find(Type type) {
        return this.rootNodes.stream().map(typeNode -> this.find(type.typeName(), (MutableTypeNode)typeNode).map(MutableTypeNode.class::cast)).flatMap(Optional::stream).findAny();
    }

    public Optional<MutableTypeNode> find(String name, MutableTypeNode node) {
        if (node.name().equals(name)) {
            return Optional.of(node);
        }
        return node.children().stream().map(newNode -> this.find(name, (MutableTypeNode)newNode)).flatMap(Optional::stream).findAny();
    }

    public Type type(String type) {
        return this.find(type).map(MutableTypeNode::type).orElse(Type.of(Identifiers.EMPTY_IDENTIFIER));
    }
}

