/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.util;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.sigmundgranaas.forgero.core.Forgero;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class JsonPOJOLoader {
    public static <T> Optional<T> loadPOJO(String filePath, Class<T> type) {
        InputStream materialsStream = JsonPOJOLoader.getInputStream(filePath);
        if (materialsStream != null) {
            try {
                JsonReader materialsJson = new JsonReader((Reader)new InputStreamReader(materialsStream));
                Object gson = new Gson().fromJson(materialsJson, type);
                return Optional.ofNullable(gson);
            }
            catch (JsonSyntaxException e) {
                Forgero.LOGGER.error("Unable to parse: {}, check if the file is valid", (Object)filePath);
                Forgero.LOGGER.error((Object)e);
                return Optional.empty();
            }
        }
        Forgero.LOGGER.error("Unable to load: {}", (Object)filePath);
        return Optional.empty();
    }

    @Nullable
    public static InputStream getInputStream(String path) {
        return JsonPOJOLoader.class.getResourceAsStream(path);
    }
}

