/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.util;

import com.sigmundgranaas.forgero.core.util.ClassToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeToken<T> {
    private final Type type;

    protected TypeToken() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        this.type = ((ParameterizedType)superclass).getActualTypeArguments()[0];
    }

    public static <T> TypeToken<T> of(Class<T> clazz) {
        return new ClassToken<T>(clazz);
    }

    public boolean equals(Object o) {
        return o instanceof TypeToken && ((TypeToken)o).type().equals(this.type());
    }

    public int hashCode() {
        return this.type().hashCode();
    }

    public boolean isInstance(Object instance) {
        Type type = this.type();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.isInstance(instance);
        }
        return false;
    }

    public T cast(Object instance) {
        Class clazz;
        if (this.type() instanceof Class && (clazz = (Class)this.type()).isInstance(instance)) {
            return clazz.cast(instance);
        }
        throw new ClassCastException("Cannot cast object to " + this.type().getTypeName());
    }

    public <R> boolean isAssignableFrom(Class<? extends R> targetClass) {
        Type type = this.type();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.isAssignableFrom(targetClass);
        }
        return false;
    }

    public <R> boolean isAssignableFrom(TypeToken<? extends R> targetClass) {
        Type type = targetClass.type();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return this.isAssignableFrom(clazz);
        }
        return false;
    }

    public Type type() {
        return this.type;
    }
}

