/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.util.loader;

import com.sigmundgranaas.forgero.core.Forgero;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;

@FunctionalInterface
public interface PathFinder {
    public static Optional<Path> ClassLoaderFinder(String path) {
        Optional<URL> url = Optional.ofNullable(PathFinder.class.getClassLoader().getResource(path)).or(() -> Optional.ofNullable(PathFinder.class.getClassLoader().getResource(path.substring(1))));
        return url.flatMap(PathFinder::uriConverter).map(Path::of);
    }

    public static Optional<Path> ClassFinder(String path) {
        Optional<URL> url = Optional.ofNullable(PathFinder.class.getResource(path)).or(() -> Optional.ofNullable(PathFinder.class.getResource(path.substring(1))));
        return url.flatMap(PathFinder::uriConverter).map(Path::of);
    }

    private static Optional<URI> uriConverter(URL url) {
        try {
            return Optional.of(url.toURI());
        }
        catch (URISyntaxException exception) {
            Forgero.LOGGER.error("Unable to convert url: {} to URI", (Object)url);
            Forgero.LOGGER.error((Object)exception);
            return Optional.empty();
        }
    }

    public Optional<Path> find(String var1);
}

