/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.core.util.match;

import com.sigmundgranaas.forgero.core.util.match.ContextKey;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.core.util.match.MutableMatchContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MatchContext
implements Matchable {
    private static final MatchContext DEFAULT = new MatchContext();
    protected final Map<String, Object> metadata;
    protected final List<Matchable> matches;

    public MatchContext() {
        this.metadata = new HashMap<String, Object>();
        this.matches = new ArrayList<Matchable>();
    }

    public static MatchContext of(KeyValuePair ... pairs) {
        MatchContext context = new MatchContext();
        Arrays.stream(pairs).forEach(pair -> context.metadata.put(pair.key().getKey(), pair.value()));
        return context;
    }

    public MatchContext(Map<String, Object> metadata, List<Matchable> matches) {
        this.metadata = new HashMap<String, Object>(metadata);
        this.matches = matches;
    }

    public MatchContext(List<Matchable> matches) {
        this.metadata = new HashMap<String, Object>();
        this.matches = matches;
    }

    public static MutableMatchContext mutable(MatchContext context) {
        if (context instanceof MutableMatchContext) {
            MutableMatchContext mut = (MutableMatchContext)context;
            return mut;
        }
        return new MutableMatchContext(new HashMap<String, Object>(context.metadata), new ArrayList<Matchable>(context.matches));
    }

    public static MatchContext of() {
        return DEFAULT;
    }

    public static MatchContext of(List<Matchable> matches) {
        return new MatchContext(matches);
    }

    public MatchContext put(String key, Object value) {
        HashMap<String, Object> metadata = new HashMap<String, Object>(this.metadata);
        metadata.put(key, value);
        return new MatchContext(metadata, new ArrayList<Matchable>(this.matches));
    }

    public MatchContext add(Matchable matchable) {
        ArrayList<Matchable> matches = new ArrayList<Matchable>(this.matches);
        if (!matches.contains(matchable)) {
            matches.add(matchable);
        }
        return new MatchContext(new HashMap<String, Object>(this.metadata), matches);
    }

    @Override
    public boolean test(Matchable match, MatchContext context) {
        return this.matches.stream().anyMatch(matchable -> matchable.test(match, context));
    }

    public <T> Optional<T> get(String key, Class<T> type) {
        Object value = this.metadata.get(key);
        if (type.isInstance(value)) {
            return Optional.of(type.cast(value));
        }
        return Optional.empty();
    }

    public <T> Optional<T> get(ContextKey<T> key) {
        return this.get(key.getKey(), key.getClazz());
    }

    public MatchContext put(ContextKey<?> key, Object value) {
        return this.put(key.getKey(), value);
    }

    public int hashCode() {
        return this.matches.hashCode() + this.metadata.hashCode();
    }

    public record KeyValuePair(ContextKey<?> key, Object value) {
    }
}

